/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.datawarehouse.store;

import com.tdunning.math.stats.AVLTreeDigest;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TTable {
    private Map<String, Integer> index;
    private List<String> rows = new ArrayList<String>();
    private List<AVLTreeDigest> digests = new ArrayList<AVLTreeDigest>();

    public TTable(InputStream inputStream) {
        this.fromBytes(inputStream);
        this.createIndex();
    }

    public TTable() {
        this.createIndex();
    }

    public int rows() {
        return this.rows.size();
    }

    public String row(int index) {
        return this.rows.get(index);
    }

    public int row(String row) {
        return this.indexOf(row);
    }

    public AVLTreeDigest value(String row) {
        return this.value(this.row(row));
    }

    public AVLTreeDigest value(int row) {
        return this.digests.get(row);
    }

    public void createRowsWith(String ... keys) {
        int i = this.rows();
        for (String key : keys) {
            this.rows.add(key);
            this.index.put(key, i++);
            this.digests.add(new AVLTreeDigest(100.0));
        }
    }

    private int indexOf(String key) {
        return this.index.getOrDefault(key, -1);
    }

    void createIndex() {
        this.index = new HashMap<String, Integer>();
        for (int i = 0; i < this.rows.size(); ++i) {
            this.index.put(this.rows.get(i), i);
        }
    }

    public byte[] toBytes() {
        try {
            return this.serialize(new ByteArrayOutputStream(65536)).toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void fromBytes(InputStream inputStream) {
        try {
            this.deserialize(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ByteArrayOutputStream serialize(ByteArrayOutputStream out) throws IOException {
        DataOutputStream stream = new DataOutputStream(out);
        this.writeString(stream, String.join((CharSequence)"\n", this.rows));
        this.writeDigests(stream);
        stream.flush();
        return out;
    }

    private void deserialize(InputStream inputStream) throws IOException {
        DataInputStream stream = new DataInputStream(inputStream);
        this.rows = new ArrayList<String>(Arrays.asList(this.readString(stream).split("\n")));
        this.digests = this.readDigests(stream);
        stream.close();
    }

    private void writeString(DataOutputStream stream, String columns) throws IOException {
        stream.writeInt(columns.length());
        stream.write(columns.getBytes("UTF-8"));
    }

    private void writeDigests(DataOutputStream stream) throws IOException {
        for (AVLTreeDigest digest : this.digests) {
            byte[] bytes = this.bytesOf(digest);
            stream.writeInt(bytes.length);
            stream.write(bytes);
        }
    }

    private String readString(DataInputStream stream) throws IOException {
        int bytes = stream.readInt();
        byte[] result = new byte[bytes];
        stream.read(result);
        return new String(result, "UTF-8");
    }

    public List<AVLTreeDigest> readDigests(DataInputStream stream) throws IOException {
        ArrayList<AVLTreeDigest> result = new ArrayList<AVLTreeDigest>();
        for (int i = 0; i < this.rows.size(); ++i) {
            byte[] array = new byte[stream.readInt()];
            stream.read(array);
            result.add(this.digestOf(array));
        }
        return result;
    }

    private byte[] bytesOf(AVLTreeDigest digest) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[digest.smallByteSize()]);
        digest.asSmallBytes(buffer);
        return buffer.array();
    }

    private AVLTreeDigest digestOf(byte[] array) {
        return AVLTreeDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(array));
    }
}

