/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.resources;

import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.ui.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.ui.displays.DisplayRepository;
import io.intino.konos.alexandria.ui.displays.Soul;
import io.intino.konos.alexandria.ui.services.push.PushService;
import io.intino.konos.alexandria.ui.services.push.UIClient;
import io.intino.konos.alexandria.ui.spark.UISparkManager;
import io.intino.konos.alexandria.ui.spark.resources.Resource;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.actions.AnalyticsPageAction;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class AnalyticsPageResource
extends Resource {
    private final SumusBox box;

    public AnalyticsPageResource(SumusBox box, UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
        this.box = box;
    }

    public void execute() throws AlexandriaException {
        super.execute();
        this.fillDeviceParameter();
        this.render();
    }

    private void render() {
        String clientId = UUID.randomUUID().toString();
        AnalyticsPageAction action = new AnalyticsPageAction();
        action.session = this.manager.currentSession();
        action.session.whenLogin((Function)new Function<String, String>(){

            @Override
            public String apply(String baseUrl) {
                return AnalyticsPageResource.this.authenticate(baseUrl);
            }
        });
        action.session.whenLogout(b -> this.logout());
        action.box = this.box;
        action.clientId = clientId;
        action.device = this.parameterValue("device");
        action.token = this.parameterValue("token");
        ((PushService)this.manager.pushService()).onOpen(client -> {
            if (!client.id().equals(action.clientId)) {
                return false;
            }
            if (client.soul() != null) {
                return false;
            }
            Soul soul = action.prepareSoul((UIClient)client);
            soul.onRedirect(location -> this.manager.redirect(location));
            soul.addRegisterDisplayListener(display -> {
                display.inject(this.notifier(action.session, (UIClient)client, (AlexandriaDisplay)display));
                display.inject(action.session);
                display.inject((DisplayRepository)soul);
                display.inject(() -> soul);
            });
            client.soul(soul);
            this.box.registerSoul(clientId, soul);
            return true;
        });
        ((PushService)this.manager.pushService()).onClose(clientId).execute((Consumer)new Consumer<UIClient>(){

            @Override
            public void accept(UIClient client) {
                AnalyticsPageResource.this.box.soul(client.id()).ifPresent(s -> s.destroy());
                AnalyticsPageResource.this.box.unRegisterSoul(client.id());
                AnalyticsPageResource.this.manager.unRegister(client);
            }
        });
        this.manager.write((Object)action.execute());
    }
}

