/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.ui.displays.AlexandriaTimeRangeNavigator;
import io.intino.konos.alexandria.ui.helpers.TimeScaleHandler;
import io.intino.konos.alexandria.ui.model.Catalog;
import io.intino.konos.alexandria.ui.model.TimeRange;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.exporters.Document;
import io.intino.sumus.analytics.exporters.XlsxDocument;
import io.intino.sumus.analytics.viewmodels.Drill;
import io.intino.sumus.analytics.viewmodels.Serie;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusChart;
import io.intino.sumus.box.displays.builders.FormatterBuilder;
import io.intino.sumus.box.displays.builders.PointsBuilder;
import io.intino.sumus.box.displays.builders.RangeBuilder;
import io.intino.sumus.box.displays.builders.ReferenceBuilder;
import io.intino.sumus.box.displays.builders.ScaleBuilder;
import io.intino.sumus.box.displays.builders.SerieBuilder;
import io.intino.sumus.box.displays.notifiers.SumusTimeSeriesChartNotifier;
import io.intino.sumus.box.schemas.CatalogInstant;
import io.intino.sumus.box.schemas.RequestRange;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.helpers.ChartSpec;
import io.intino.sumus.queries.TimeSeriesQuery;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SumusTimeSeriesChart
extends SumusChart<SumusTimeSeriesChartNotifier, AlexandriaTimeRangeNavigator> {
    private Map<Ticket, List<String>> ticketToSeries = new HashMap<Ticket, List<String>>();
    private boolean shouldClearWidget = false;
    private List<Catalog> catalogs = new ArrayList<Catalog>();

    public SumusTimeSeriesChart(SumusBox box) {
        super(box, new AlexandriaTimeRangeNavigator((Box)box));
    }

    @Override
    public void timeScaleHandler(TimeScaleHandler timeScaleHandler) {
        super.timeScaleHandler(timeScaleHandler);
        timeScaleHandler.onRangeChange(this::refreshRange);
    }

    @Override
    public boolean isValidSpecification(ChartSpec spec) {
        return spec.ticketList().size() > 0;
    }

    public void refreshRange(TimeRange timeRange) {
        ((SumusTimeSeriesChartNotifier)this.notifier).timeRange(RangeBuilder.build(timeRange));
    }

    public void refreshChart(TimeRange timeRange) {
        this.notifyLoading(true);
        this.shouldClearWidget = true;
        ((SumusTimeSeriesChartNotifier)this.notifier).timeRange(RangeBuilder.build(timeRange));
        ((SumusTimeSeriesChartNotifier)this.notifier).updateScale(ScaleBuilder.build(timeRange.scale(), this.currentLanguage()));
        this.specification().ticketList().forEach(this::addSeries);
        this.shouldClearWidget = false;
        this.notifyLoading(false);
        if (!this.isShowingEvents()) {
            this.loadMorePointsOnLeftAndRight(this.tickets());
        }
    }

    @Override
    public Document export(Instant from, Instant to) {
        TimeRange range = new TimeRange(from, to, this.timeScaleHandler().range().scale());
        TimeSeriesQuery query = this.buildQuery(range, this.tickets());
        return XlsxDocument.export(this.queryEngine().document(query), this.currentLanguage());
    }

    public void moveLeft(Long value) {
        TimeRange timeRange = this.timeScaleHandler().moveLeft(value.longValue());
        this.refresh(timeRange);
    }

    public void moveRight(Long value) {
        TimeRange timeRange = this.timeScaleHandler().moveRight(value.longValue());
        this.refresh(timeRange);
    }

    public void updateRangeAndScale(RequestRange range) {
        this.updateRangeAndScale(range.from(), range.to());
    }

    public void updateRangeAndScale(Instant from, Instant to) {
        this.updateRange(from, to, true);
    }

    @Override
    public boolean isShowingEvents() {
        return this.tickets().length != 0 && this.tickets()[0].range().eventHorizon().ordinal() < this.timeScaleHandler().range().scale().ordinal();
    }

    @Override
    public boolean allowTemporalFiltering() {
        return false;
    }

    @Override
    public Categorization byCategorization() {
        return null;
    }

    @Override
    protected void init() {
        super.init();
        ((SumusTimeSeriesChartNotifier)this.notifier).olapRange(RangeBuilder.build(this.timeScaleHandler().boundsRange()));
        ((SumusTimeSeriesChartNotifier)this.notifier).timeRange(RangeBuilder.build(this.timeScaleHandler().range()));
        ((SumusTimeSeriesChartNotifier)this.notifier).formats(FormatterBuilder.buildList(this.instantFormatter().formatterList()));
        ((SumusTimeSeriesChartNotifier)this.notifier).updateScale(ScaleBuilder.build(this.timeScaleHandler().range().scale(), this.currentLanguage()));
        ((SumusTimeSeriesChartNotifier)this.notifier).refreshCatalogList(ReferenceBuilder.buildCatalogList(this.catalogs));
    }

    @Override
    protected void update() {
        this.clearTickets();
        this.timeScaleHandler().resetLoadedPoints();
        ((SumusTimeSeriesChartNotifier)this.notifier).refreshTicketCount(this.specification().ticketList().size());
        this.refreshChart(this.timeScaleHandler().range());
    }

    @Override
    public void addNavigatorListeners(AlexandriaTimeRangeNavigator display) {
        display.onFromChange(this::refreshChart);
        display.onToChange(this::refreshChart);
        display.onMove(this::refresh);
        display.onMoveNext(this::refresh);
        display.onMovePrevious(this::refresh);
    }

    @Override
    public boolean allowMultipleTickets() {
        return true;
    }

    @Override
    public boolean allowDrill() {
        return true;
    }

    public void refresh() {
        super.refresh();
        this.refreshChart(this.timeScaleHandler().range());
    }

    @Override
    public void showDialog() {
        super.showDialog();
    }

    public void catalogs(List<Catalog> catalogs) {
        this.catalogs = catalogs;
    }

    public void selectCatalogInstant(CatalogInstant instant) {
        List<String> entities = this.entitiesOf(instant);
        this.notifySelectInstant(instant, entities);
    }

    private List<String> entitiesOf(CatalogInstant instant) {
        TimeSeriesQuery query = this.buildQuery(new TimeStamp(instant.value(), this.timeScaleHandler().range().scale()), this.tickets());
        return this.queryEngine().entities(query);
    }

    private void addSeries(Ticket ticket) {
        if (this.shouldShowEvents(ticket)) {
            this.showEvents(ticket);
        } else {
            this.showIndicators(ticket);
        }
    }

    private void loadMorePointsOnLeftAndRight(Ticket ... tickets) {
        this.showMorePoints(this.timeScaleHandler().leftRange(), tickets);
        this.showMorePoints(this.timeScaleHandler().rightRange(), tickets);
    }

    private void showMorePoints(TimeRange range, Ticket ... tickets) {
        TimeSeriesQuery query = this.buildQuery(range, tickets);
        List<Serie> serieList = this.queryEngine().timeSeries(query);
        ((SumusTimeSeriesChartNotifier)this.notifier).addPoints(PointsBuilder.build(serieList, this.timeScaleHandler().range().scale(), this.currentLanguage()));
    }

    private TimeSeriesQuery buildQuery(TimeRange timeRange, Ticket ... tickets) {
        return this.createBuilder(tickets).build(this.nameSpace(), timeRange);
    }

    private TimeSeriesQuery buildQuery(TimeStamp timeStamp, Ticket ... tickets) {
        return this.createBuilder(tickets).build(this.nameSpace(), timeStamp);
    }

    private TimeSeriesQuery.Builder createBuilder(Ticket ... tickets) {
        TimeSeriesQuery.Builder builder = new TimeSeriesQuery.Builder().addTickets(Arrays.asList(tickets));
        ChartSpec spec = this.specification();
        Drill drill = spec.drill();
        if (drill != null) {
            builder.drill(drill.categorization, drill.tags);
        }
        spec.filterList().stream().filter(f -> !(f.categorization instanceof TemporalCategorization)).forEach(f -> builder.filter(f.categorization, f.tags));
        builder.includeGlobalSerie(spec.includeGlobalSerie());
        builder.scope(spec.scope());
        return builder;
    }

    private boolean shouldShowEvents() {
        Ticket[] tickets = this.tickets();
        if (tickets.length <= 0) {
            return false;
        }
        return this.shouldShowEvents(tickets[0]);
    }

    private boolean shouldShowEvents(Ticket ticket) {
        Ticket.Range range = ticket.range();
        return range.eventHorizon().ordinal() < this.timeScaleHandler().range().scale().ordinal();
    }

    private void showEvents(Ticket ticket) {
    }

    private void showIndicators(Ticket ticket) {
        List<Serie> serieList = this.queryEngine().timeSeries(this.buildQuery(this.timeScaleHandler().range(), ticket));
        this.ticketToSeries.put(ticket, serieList.stream().map(Serie::label).collect(Collectors.toList()));
        if (this.shouldClearWidget) {
            ((SumusTimeSeriesChartNotifier)this.notifier).clear();
            this.shouldClearWidget = false;
        }
        ((SumusTimeSeriesChartNotifier)this.notifier).addSeries(SerieBuilder.buildList(serieList));
    }

    private Ticket[] tickets() {
        List<Ticket> result = this.ticketToSeries.keySet().stream().filter(Objects::nonNull).collect(Collectors.toList());
        return result.toArray(new Ticket[result.size()]);
    }

    private void updateRange(Instant from, Instant to, boolean updateScaleIfNeeded) {
        this.timeScaleHandler().updateRange(from, to, updateScaleIfNeeded);
        if (this.shouldShowEvents()) {
            this.showEvents(this.tickets()[0]);
        }
    }

    private void refresh(TimeRange timeRange) {
        if (this.shouldShowEvents()) {
            this.showEvents(this.tickets()[0]);
        } else {
            this.showMorePoints(timeRange, this.tickets());
        }
    }

    private void removeTicket(Ticket ticket) {
        ((SumusTimeSeriesChartNotifier)this.notifier).removeSeries(this.ticketToSeries.remove((Object)ticket));
    }

    private void clearTickets() {
        HashSet<Ticket> tickets = new HashSet<Ticket>();
        tickets.addAll(this.ticketToSeries.keySet());
        tickets.forEach(this::removeTicket);
    }
}

