/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.alexandria.ui.displays.AlexandriaTimeNavigator;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusTimeHistogramDialog;
import io.intino.sumus.box.displays.builders.ReferenceBuilder;
import io.intino.sumus.box.displays.builders.TicketBuilder;
import io.intino.sumus.box.displays.notifiers.SumusTimeScatterChartDialogNotifier;
import io.intino.sumus.box.schemas.ScatterQuery;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.graph.rules.Chart;
import io.intino.sumus.helpers.ChartSpec;
import io.intino.sumus.helpers.ChartSpecHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SumusTimeScatterChartDialog
extends SumusTimeHistogramDialog<SumusTimeScatterChartDialogNotifier> {
    private Ticket xAxis = null;
    private Ticket yAxis = null;
    private Ticket radius = null;
    private Ticket color = null;

    public SumusTimeScatterChartDialog(SumusBox box) {
        super(box, Chart.TimeScatterChart, "scatter");
    }

    @Override
    public void selectTickets(String[] tickets) {
        this.chartSpecHandler().selectTickets(tickets);
        this.resetTickets();
        this.refreshSpecificationTickets();
        this.chartSpecHandler().update();
    }

    @Override
    protected void init() {
        super.init();
        this.resetTickets();
        this.sendTickets();
    }

    public void refresh() {
        super.refresh();
        this.sendTickets();
    }

    @Override
    protected void update() {
        this.resetTickets();
        super.update();
    }

    @Override
    protected void sendTickets() {
        ((SumusTimeScatterChartDialogNotifier)this.notifier).refreshTicketList(TicketBuilder.buildList((List<Ticket>)new ArrayList<Ticket>(){
            {
                this.add(SumusTimeScatterChartDialog.this.xAxis);
                this.add(SumusTimeScatterChartDialog.this.yAxis);
                this.add(SumusTimeScatterChartDialog.this.radius);
                this.add(SumusTimeScatterChartDialog.this.color);
            }
        }));
    }

    @Override
    public void addNavigatorListeners(AlexandriaTimeNavigator display) {
        display.onMove(instant -> this.chartSpecHandler().update());
    }

    @Override
    protected void sendCategorizations() {
        ((SumusTimeScatterChartDialogNotifier)this.notifier).refreshCategorizationList(ReferenceBuilder.buildList(this.categorizations()));
    }

    @Override
    protected void sendCategorization() {
        ((SumusTimeScatterChartDialogNotifier)this.notifier).refreshCategorization(ReferenceBuilder.build(this.categorization()));
    }

    public void query(ScatterQuery query) {
        this.refreshSpecification(query);
        this.chartSpecHandler().update();
    }

    private Ticket ticketOf(String key) {
        return this.specification().ticketList().stream().filter(t -> t.name$().equals(key) || t.label().equals(key)).findFirst().orElse(null);
    }

    private void resetTickets() {
        ChartSpec specification = this.specification();
        List<Ticket> ticketList = specification.ticketList("xAxis");
        this.xAxis = ticketList.size() > 0 ? ticketList.get(0) : null;
        ticketList = specification.ticketList("yAxis");
        this.yAxis = ticketList.size() > 0 ? ticketList.get(0) : null;
        ticketList = specification.ticketList("radius");
        this.radius = ticketList.size() > 0 ? ticketList.get(0) : null;
        ticketList = specification.ticketList("color");
        this.color = ticketList.size() > 0 ? ticketList.get(0) : null;
        this.addNotQualifiedTickets();
        this.refreshTags();
    }

    private void addNotQualifiedTickets() {
        for (Ticket ticket : this.specification().ticketList()) {
            if (ticket == this.xAxis || ticket == this.yAxis || ticket == this.radius || ticket == this.color) continue;
            if (this.xAxis == null) {
                this.xAxis = ticket;
                continue;
            }
            if (this.yAxis == null) {
                this.yAxis = ticket;
                continue;
            }
            if (this.radius == null) {
                this.radius = ticket;
                continue;
            }
            if (this.color != null) continue;
            this.color = ticket;
        }
    }

    private void refreshTags() {
        ChartSpecHandler chartSpecHandler = this.chartSpecHandler();
        if (this.xAxis != null) {
            chartSpecHandler.setTicketTags(this.xAxis, Collections.singletonList("xAxis"));
        }
        if (this.yAxis != null) {
            chartSpecHandler.setTicketTags(this.yAxis, Collections.singletonList("yAxis"));
        }
        if (this.radius != null) {
            chartSpecHandler.setTicketTags(this.radius, Collections.singletonList("radius"));
        }
        if (this.color != null) {
            chartSpecHandler.setTicketTags(this.color, Collections.singletonList("color"));
        }
    }

    private void refreshSpecification(ScatterQuery query) {
        this.refreshSpecificationTickets(query);
        this.refreshSpecificationCategorization(query);
        this.refreshSpecificationHeatMap(query);
    }

    private void refreshSpecificationTickets(ScatterQuery query) {
        this.xAxis = this.ticketOf(query.xAxis());
        this.yAxis = this.ticketOf(query.yAxis());
        this.radius = this.ticketOf(query.radius());
        this.color = this.ticketOf(query.color());
        this.refreshSpecificationTickets();
        this.sendTickets();
    }

    private void refreshSpecificationTickets() {
        ChartSpecHandler chartSpecHandler = this.chartSpecHandler();
        chartSpecHandler.clearTicketsTag("xAxis");
        chartSpecHandler.clearTicketsTag("yAxis");
        chartSpecHandler.clearTicketsTag("radius");
        chartSpecHandler.clearTicketsTag("color");
        chartSpecHandler.selectTickets((Map<Ticket, List<String>>)new LinkedHashMap<Ticket, List<String>>(){
            {
                if (SumusTimeScatterChartDialog.this.xAxis != null) {
                    this.put(SumusTimeScatterChartDialog.this.xAxis, Collections.singletonList("xAxis"));
                }
                if (SumusTimeScatterChartDialog.this.yAxis != null) {
                    this.put(SumusTimeScatterChartDialog.this.yAxis, Collections.singletonList("yAxis"));
                }
                if (SumusTimeScatterChartDialog.this.radius != null) {
                    this.put(SumusTimeScatterChartDialog.this.radius, Collections.singletonList("radius"));
                }
                if (SumusTimeScatterChartDialog.this.color != null) {
                    this.put(SumusTimeScatterChartDialog.this.color, Collections.singletonList("color"));
                }
            }
        });
        this.sendTickets();
    }

    private void refreshSpecificationCategorization(ScatterQuery query) {
        ChartSpecHandler chartSpecHandler = this.chartSpecHandler();
        Categorization categorization = this.categorizationOf(query.categorization());
        chartSpecHandler.clearCategorizationsTag("scatter");
        chartSpecHandler.selectCategorizations(Collections.singletonMap(categorization, Collections.singletonList("scatter")));
        this.sendCategorization();
    }

    private void refreshSpecificationHeatMap(final ScatterQuery query) {
        this.chartSpecHandler().heatMap(query.heatMap() != null ? new ChartSpec.HeatMap(){

            @Override
            public String minColor() {
                return query.heatMap().min();
            }

            @Override
            public String maxColor() {
                return query.heatMap().max();
            }
        } : null);
    }
}

