/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.viewmodels.Histogram;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusTimeHistogram;
import io.intino.sumus.box.displays.builders.HistogramBuilder;
import io.intino.sumus.box.displays.builders.ReferenceBuilder;
import io.intino.sumus.box.displays.builders.TicketBuilder;
import io.intino.sumus.box.displays.notifiers.SumusTimeScatterChartNotifier;
import io.intino.sumus.box.schemas.HeatMap;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.helpers.ChartSpec;
import java.util.ArrayList;
import java.util.List;

public class SumusTimeScatterChart
extends SumusTimeHistogram<SumusTimeScatterChartNotifier> {
    public static final String XAxisTag = "xAxis";
    public static final String YAxisTag = "yAxis";
    public static final String RadiusTag = "radius";
    public static final String ColorTag = "color";
    public static final String ScatterTag = "scatter";

    public SumusTimeScatterChart(SumusBox box) {
        super(box, ScatterTag);
    }

    @Override
    public void update() {
        this.sendTicketList();
        super.update();
    }

    @Override
    public boolean isValidSpecification(ChartSpec spec) {
        return spec.ticketList(XAxisTag).size() == 1 && spec.ticketList(YAxisTag).size() == 1 && this.categorization() != null;
    }

    @Override
    protected void init() {
        super.init();
        this.sendTicketList();
    }

    @Override
    protected void sendCategorization() {
        Categorization categorization = this.categorization();
        ((SumusTimeScatterChartNotifier)this.notifier).refreshCategorization(categorization != null ? ReferenceBuilder.build(categorization) : null);
    }

    @Override
    protected void sendTicketCount() {
        this.sendTicketList();
    }

    @Override
    protected void sendHistogram(Histogram histogram) {
        io.intino.sumus.box.schemas.Histogram histogramSchema = HistogramBuilder.build(histogram);
        ChartSpec.HeatMap heatMap = this.specification().heatMap();
        histogramSchema.heatMap(heatMap != null ? this.heatMapOf(heatMap) : null);
        ((SumusTimeScatterChartNotifier)this.notifier).refreshHistogram(histogramSchema);
    }

    private HeatMap heatMapOf(ChartSpec.HeatMap heatMap) {
        return new HeatMap().min(heatMap.minColor()).max(heatMap.maxColor());
    }

    private void sendTicketList() {
        final ChartSpec specification = this.specification();
        ((SumusTimeScatterChartNotifier)this.notifier).refreshTicketList(TicketBuilder.buildList((List<Ticket>)new ArrayList<Ticket>(){
            {
                this.add(specification.ticketList(SumusTimeScatterChart.XAxisTag).stream().findFirst().orElse(null));
                this.add(specification.ticketList(SumusTimeScatterChart.YAxisTag).stream().findFirst().orElse(null));
                this.add(specification.ticketList(SumusTimeScatterChart.RadiusTag).stream().findFirst().orElse(null));
                this.add(specification.ticketList(SumusTimeScatterChart.ColorTag).stream().findFirst().orElse(null));
            }
        }));
    }

    @Override
    public void showDialog() {
        super.showDialog();
    }
}

