/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.ui.displays.AlexandriaTimeNavigator;
import io.intino.konos.alexandria.ui.helpers.TimeScaleHandler;
import io.intino.konos.alexandria.ui.model.TimeRange;
import io.intino.konos.alexandria.ui.model.TimeScale;
import io.intino.sumus.analytics.Scaler;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.exporters.Document;
import io.intino.sumus.analytics.viewmodels.CrossTable;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusChart;
import io.intino.sumus.box.displays.notifiers.SumusTimeCrossTableNotifier;
import io.intino.sumus.box.schemas.Column;
import io.intino.sumus.box.schemas.CrossTableData;
import io.intino.sumus.box.schemas.DecimalPlaces;
import io.intino.sumus.box.schemas.Entry;
import io.intino.sumus.box.schemas.HeatMap;
import io.intino.sumus.box.schemas.Row;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.helpers.ChartSpec;
import io.intino.sumus.helpers.MathHelper;
import io.intino.sumus.queries.CrossTableQuery;
import io.intino.tara.magritte.Layer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SumusTimeCrossTable
extends SumusChart<SumusTimeCrossTableNotifier, AlexandriaTimeNavigator> {
    public static final int TemporalCategorizationOffset = 2;
    private Map<String, List<String>> tagsSelection = new HashMap<String, List<String>>();
    public static final String ColumnTag = "column";
    public static final String RowTag = "row";

    public SumusTimeCrossTable(SumusBox box) {
        super(box, new AlexandriaTimeNavigator((Box)box));
    }

    @Override
    public void timeScaleHandler(TimeScaleHandler timeScaleHandler) {
        super.timeScaleHandler(timeScaleHandler);
        timeScaleHandler.onScaleChange(this::doQuery);
    }

    @Override
    public boolean isValidSpecification(ChartSpec spec) {
        return spec.ticketList().size() == 1 && spec.categorizationList(ColumnTag).size() > 0 && spec.categorizationList(RowTag).size() > 0;
    }

    @Override
    public Document export(Instant from, Instant to) {
        return null;
    }

    @Override
    public boolean isShowingEvents() {
        return false;
    }

    @Override
    public boolean allowTemporalFiltering() {
        return true;
    }

    @Override
    public Categorization byCategorization() {
        return null;
    }

    public void refresh() {
        super.refresh();
        this.doQuery(this.timeScaleHandler().range());
    }

    @Override
    public void addNavigatorListeners(AlexandriaTimeNavigator display) {
        display.onMove(this::doQuery);
    }

    @Override
    public boolean allowMultipleTickets() {
        return false;
    }

    @Override
    public boolean allowDrill() {
        return false;
    }

    @Override
    protected void update() {
        ((SumusTimeCrossTableNotifier)this.notifier).refreshTicketCount(this.specification().ticketList().size());
        this.filter(this.specification().filterList());
    }

    private void doQuery() {
        this.notifyLoading(true);
        ((SumusTimeCrossTableNotifier)this.notifier).loading(true);
        ((SumusTimeCrossTableNotifier)this.notifier).refreshData(this.isValidQuery() ? this.data() : this.emptyData());
        this.notifyLoading(false);
        ((SumusTimeCrossTableNotifier)this.notifier).loading(false);
    }

    private void doQuery(Instant instant) {
        this.doQuery();
    }

    private void doQuery(TimeRange range) {
        this.doQuery();
    }

    private CrossTableData data() {
        List<Column> columns = this.columns();
        List<Row> rows = this.rows();
        CrossTable crossTable = this.isValidQuery() ? this.queryEngine().crossTable(this.queryOf(this.range())) : null;
        Scaler scaler = crossTable != null ? crossTable.scaler() : null;
        ChartSpec.HeatMap heatMap = this.specification().heatMap();
        return new CrossTableData().decimalPlaces(this.decimalPlaces()).columnList(columns).rowList(rows).entryList(this.entries(crossTable, scaler, columns, rows)).unitLabel(scaler != null ? scaler.unitLabel() : "").heatMap(heatMap != null ? this.heatMapOf(heatMap) : null);
    }

    private TimeRange range() {
        TimeScale scale = ((AlexandriaTimeNavigator)this.navigatorDisplay()).scale();
        Instant date = ((AlexandriaTimeNavigator)this.navigatorDisplay()).date();
        return new TimeRange(date, scale.addTo(date, 1L), scale);
    }

    private CrossTableData emptyData() {
        return new CrossTableData().entryList(new ArrayList<Entry>()).columnList(this.columns()).rowList(this.rows());
    }

    private DecimalPlaces decimalPlaces() {
        DecimalPlaces result = new DecimalPlaces();
        Ticket ticket = this.ticket();
        if (ticket == null) {
            return result;
        }
        Ticket.DecimalPlaces decimalPlaces = ticket.decimalPlaces();
        return result.absolute(decimalPlaces.absolute()).percentage(decimalPlaces.percentage());
    }

    private HeatMap heatMapOf(ChartSpec.HeatMap heatMap) {
        return new HeatMap().min(heatMap.minColor()).max(heatMap.maxColor());
    }

    private List<Column> columns() {
        List<String> cols = this.specification().categorizationList(ColumnTag).stream().map(Layer::name$).collect(Collectors.toList());
        return this.filterValid(cols).stream().map(this::columnOf).collect(Collectors.toList());
    }

    private Column columnOf(Categorization categorization) {
        List selection = this.tagsSelection.getOrDefault(categorization.label(), null);
        List<String> collect = categorization.tags(this.accessList()).stream().filter((? super T c) -> selection == null || selection.contains(c)).collect(Collectors.toList());
        if (!(categorization instanceof TemporalCategorization)) {
            collect.sort(Comparator.naturalOrder());
        }
        return new Column().label(categorization.label()).values(collect);
    }

    private List<Row> rows() {
        List<String> rows = this.specification().categorizationList(RowTag).stream().map(Layer::name$).collect(Collectors.toList());
        return this.filterValid(rows).stream().map(this::rowOf).collect(Collectors.toList());
    }

    private Row rowOf(Categorization categorization) {
        List selection = this.tagsSelection.getOrDefault(categorization.label(), null);
        List<String> collect = categorization.tags(this.accessList()).stream().filter((? super T c) -> selection == null || selection.contains(c)).collect(Collectors.toList());
        if (!(categorization instanceof TemporalCategorization)) {
            collect.sort(Comparator.naturalOrder());
        }
        return new Row().label(categorization.label()).values(collect);
    }

    private boolean isValidCategorization(Categorization categorization) {
        if (!(categorization instanceof TemporalCategorization)) {
            return true;
        }
        TimeScale scale = this.timeScaleHandler().range().scale();
        return SumusTimeCrossTable.isAvailableForScale((TemporalCategorization)categorization, scale);
    }

    private List<String> tagsOf(Categorization categorization, List<String> tags) {
        if (tags == null || tags.size() == 0) {
            return categorization.tags(this.accessList());
        }
        return categorization.tags(this.accessList()).stream().filter(tags::contains).collect(Collectors.toList());
    }

    private List<Entry> entries(CrossTable crossTable, Scaler scaler, List<Column> columns, List<Row> rows) {
        if (this.ticket() == null || crossTable == null) {
            return Collections.emptyList();
        }
        ArrayList<Entry> result = new ArrayList<Entry>();
        Set<Set<Object>> columnsCartesianProduct = this.columnsCartesianProduct(columns);
        Set<Set<Object>> rowsCartesianProduct = this.rowsCartesianProduct(rows);
        rowsCartesianProduct.forEach(rowSet -> {
            List rowTags = rowSet.stream().map(Object::toString).collect(Collectors.toList());
            Entry entry = new Entry();
            columnsCartesianProduct.forEach(columnSet -> {
                List columnTags = columnSet.stream().map(Object::toString).collect(Collectors.toList());
                ArrayList<String> tags = new ArrayList<String>(columnTags);
                tags.addAll(rowTags);
                entry.values().add(scaler.scale(crossTable.value(tags)));
            });
            result.add(entry);
        });
        return result;
    }

    private CrossTableQuery queryOf(TimeRange timeRange) {
        CrossTableQuery.Builder builder = new CrossTableQuery.Builder().filter(this.specification().filterList());
        this.columns().forEach(column -> {
            Categorization categorization = this.categorizationOf(column.label());
            builder.addColumn(categorization, this.tagsOf(categorization, column.values()));
        });
        this.rows().forEach(row -> {
            Categorization categorization = this.categorizationOf(row.label());
            builder.addRow(categorization, this.tagsOf(categorization, row.values()));
        });
        builder.scope(this.specification().scope());
        return builder.build(this.nameSpace(), this.ticket(), timeRange);
    }

    private List<Categorization> filterValid(List<String> categorizations) {
        return categorizations.stream().map(this::categorizationOf).filter(this::isValidCategorization).collect(Collectors.toList());
    }

    private Set<Set<Object>> columnsCartesianProduct(List<Column> columns) {
        ArrayList<List<String>> cartesianColumns = new ArrayList<List<String>>();
        for (Column column : columns) {
            Categorization categorization = this.categorizationOf(column.label());
            List<String> collect = this.tagsOf(categorization, column.values());
            if (!(categorization instanceof TemporalCategorization)) {
                collect.sort(Comparator.naturalOrder());
            }
            cartesianColumns.add(collect);
        }
        return this.cartesianProduct(cartesianColumns);
    }

    private Set<Set<Object>> rowsCartesianProduct(List<Row> rows) {
        ArrayList<List<String>> cartesianRows = new ArrayList<List<String>>();
        for (Row row : rows) {
            Categorization categorization = this.categorizationOf(row.label());
            List<String> collect = this.tagsOf(categorization, row.values());
            if (!(categorization instanceof TemporalCategorization)) {
                collect.sort(Comparator.naturalOrder());
            }
            cartesianRows.add(collect);
        }
        return this.cartesianProduct(cartesianRows);
    }

    private Set<Set<Object>> cartesianProduct(final List<List<String>> values) {
        Set[] set = new Set[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            set[i] = new LinkedHashSet(values.get(i));
        }
        if (set.length == 1) {
            return new LinkedHashSet<Set<Object>>(){
                {
                    ((List)values.get(0)).forEach(value -> this.add(new LinkedHashSet<Object>(){
                        {
                            this.add(value);
                        }
                    }));
                }
            };
        }
        return MathHelper.cartesianProduct(set);
    }

    private Ticket ticket() {
        List<Ticket> ticketList = this.specification().ticketList();
        return ticketList.size() > 0 ? ticketList.get(0) : null;
    }

    private void filter(List<FilterCondition> filters) {
        this.tagsSelection.clear();
        filters.forEach(filterCondition -> {
            Categorization categorization = filterCondition.categorization;
            String categorizationLabel = categorization.label();
            if (filterCondition.tags.size() == 0) {
                this.tagsSelection.remove(categorizationLabel);
            } else {
                this.tagsSelection.put(categorizationLabel, filterCondition.tags);
            }
        });
        this.doQuery(this.timeScaleHandler().range());
    }

    private boolean isValidQuery() {
        return this.specification().ticketList().size() == 1 && this.columns().size() > 0 && this.rows().size() > 0;
    }

    @Override
    public void showDialog() {
        super.showDialog();
    }

    static boolean isAvailableForScale(TemporalCategorization categorization, TimeScale scale) {
        int ownScale = categorization.range().scale().ordinal();
        return ownScale >= scale.ordinal() && ownScale <= scale.ordinal() + 2;
    }
}

