/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.alexandria.ui.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.ui.helpers.TimeScaleHandler;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusChartDialog;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.SumusTimeBarChartDialog;
import io.intino.sumus.box.displays.SumusTimeCrossTableDialog;
import io.intino.sumus.box.displays.SumusTimeScatterChartDialog;
import io.intino.sumus.box.displays.SumusTimeSeriesChartDialog;
import io.intino.sumus.box.displays.builders.TicketBuilder;
import io.intino.sumus.box.displays.notifiers.SumusTimeChartDesignNotifier;
import io.intino.sumus.graph.rules.Chart;
import io.intino.sumus.helpers.ChartSpec;
import io.intino.sumus.helpers.ChartSpecHandler;
import java.util.List;
import java.util.Optional;

public class SumusTimeChartDesign
extends SumusDisplay<SumusTimeChartDesignNotifier> {
    private TimeScaleHandler timeScaleHandler;
    private ChartSpecHandler chartSpecHandler;
    private Chart selectedChart = null;

    public SumusTimeChartDesign(SumusBox box) {
        super(box);
    }

    public void timeScaleHandler(TimeScaleHandler timeScaleHandler) {
        this.timeScaleHandler = timeScaleHandler;
    }

    public void chartSpecHandler(ChartSpecHandler chartSpecHandler) {
        this.chartSpecHandler = chartSpecHandler;
        this.chartSpecHandler.onChange(this::refresh);
    }

    public void selectChart(Chart chart) {
        this.selectedChart = chart;
        ((SumusTimeChartDesignNotifier)this.notifier).refreshSelectedChart(chart.toString());
    }

    public void selectTickets(String[] tickets) {
        this.dialogDisplay().ifPresent(d -> d.selectTickets(tickets));
    }

    protected void init() {
        super.init();
        this.buildChartDialogs();
        ((SumusTimeChartDesignNotifier)this.notifier).refreshTicketList(TicketBuilder.buildList(this.chartSpecHandler.olapTickets()));
    }

    public void refresh() {
        super.refresh();
        this.refresh(this.chartSpecHandler.specification());
    }

    private void refresh(ChartSpec chartSpec) {
        ((SumusTimeChartDesignNotifier)this.notifier).refreshSelectedTicketList(TicketBuilder.buildList(chartSpec.ticketList()));
    }

    private void buildChartDialogs() {
        this.add(new SumusTimeSeriesChartDialog((SumusBox)this.box));
        this.add(new SumusTimeCrossTableDialog((SumusBox)this.box));
        this.add(new SumusTimeBarChartDialog((SumusBox)this.box));
        this.add(new SumusTimeScatterChartDialog((SumusBox)this.box));
    }

    private void add(SumusChartDialog display) {
        display.timeScaleHandler(this.timeScaleHandler);
        display.chartSpecHandler(this.chartSpecHandler);
        this.addAndPersonify((AlexandriaDisplay)display);
    }

    public void updateTemporalCategorizations(List<TemporalCategorization> categorizations) {
        ((SumusTimeCrossTableDialog)this.child(SumusTimeCrossTableDialog.class)).updateTemporalCategorizations(categorizations);
    }

    private Optional<SumusChartDialog> dialogDisplay() {
        return this.children(SumusChartDialog.class).stream().filter(d -> d.type() == this.selectedChart).findFirst();
    }
}

