/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.alexandria.ui.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.ui.displays.CatalogInstantBlock;
import io.intino.konos.alexandria.ui.helpers.Bounds;
import io.intino.konos.alexandria.ui.helpers.TimeScaleHandler;
import io.intino.konos.alexandria.ui.model.Catalog;
import io.intino.konos.alexandria.ui.model.TimeRange;
import io.intino.konos.alexandria.ui.model.TimeScale;
import io.intino.konos.alexandria.ui.spark.UIFile;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.categorization.TemporalCategorizationFactory;
import io.intino.sumus.analytics.exporters.Document;
import io.intino.sumus.analytics.viewmodels.Drill;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusAnalyze;
import io.intino.sumus.box.displays.SumusChart;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.SumusTimeBarChart;
import io.intino.sumus.box.displays.SumusTimeCrossTable;
import io.intino.sumus.box.displays.SumusTimeScatterChart;
import io.intino.sumus.box.displays.SumusTimeSeriesChart;
import io.intino.sumus.box.displays.builders.DrillBuilder;
import io.intino.sumus.box.displays.builders.FilterBuilder;
import io.intino.sumus.box.displays.builders.RangeBuilder;
import io.intino.sumus.box.displays.builders.ReferenceBuilder;
import io.intino.sumus.box.displays.builders.ScaleBuilder;
import io.intino.sumus.box.displays.builders.TicketBuilder;
import io.intino.sumus.box.displays.notifiers.SumusOlapNotifier;
import io.intino.sumus.box.schemas.Chart;
import io.intino.sumus.box.schemas.ChartOption;
import io.intino.sumus.box.schemas.RequestRange;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.Indicator;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.StackedIndicator;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.graph.rules.Mode;
import io.intino.sumus.helpers.ChartSpec;
import io.intino.sumus.helpers.ChartSpecHandler;
import io.intino.sumus.helpers.NameSpaceHandler;
import io.intino.sumus.queries.Scope;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class SumusOlap
extends SumusDisplay<SumusOlapNotifier> {
    private static final Logger LOG = Logger.getLogger(SumusOlap.class.getName());
    private Olap olap;
    private NameSpaceHandler nameSpaceHandler;
    private TimeScaleHandler timeScaleHandler;
    private ChartSpecHandler chartSpecHandler;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<Consumer<CatalogInstantBlock>> selectListeners = new ArrayList<Consumer<CatalogInstantBlock>>();
    private Map<io.intino.sumus.graph.rules.Chart, Function<io.intino.sumus.graph.rules.Chart, SumusChart>> chartDisplayBuilders = new HashMap<io.intino.sumus.graph.rules.Chart, Function<io.intino.sumus.graph.rules.Chart, SumusChart>>();
    private Map<io.intino.sumus.graph.rules.Chart, SumusChart> chartDisplayMap = new HashMap<io.intino.sumus.graph.rules.Chart, SumusChart>();
    private io.intino.sumus.graph.rules.Chart selectedChart = null;
    private List<Ticket> lastSelectedTickets = new ArrayList<Ticket>();
    private Scope scope = null;

    public SumusOlap(SumusBox box) {
        super(box);
        this.fillBuilders();
    }

    private static Stream<Indicator> indicators(List<Ticket> tickets) {
        return tickets.stream().filter((? super T ticket) -> ticket.dataRetriever().i$(Indicator.class)).map(ticket -> ticket.dataRetriever().i$(MeasureIndicator.class) ? Collections.singletonList(ticket.dataRetriever().a$(MeasureIndicator.class)) : ((StackedIndicator)ticket.dataRetriever().a$(StackedIndicator.class)).measureIndicatorList()).flatMap(Collection::stream);
    }

    public SumusOlap olap(Olap olap) {
        this.olap = olap;
        return this;
    }

    public Olap olap() {
        return this.olap;
    }

    public void nameSpaceHandler(NameSpaceHandler nameSpaceHandler) {
        this.nameSpaceHandler = nameSpaceHandler;
        this.nameSpaceHandler.onSelect(this::selectNameSpace);
    }

    public void scope(Scope scope) {
        this.chartSpecHandler.setScope(scope);
        this.chartSpecHandler.update();
    }

    public void refresh() {
        super.refresh();
        if (this.selectedChart == null && this.olap.charts().size() > 0) {
            this.selectChart(this.olap.charts().get(0), null);
        } else {
            this.chartDisplay().ifPresent(SumusChart::update);
        }
        this.updateActions();
    }

    public void addTicket(String label) {
        if (label == null) {
            return;
        }
        this.addTicket(this.ticket(label));
    }

    public void addTicket(Ticket ticket) {
        this.chartSpecHandler.addTicket(ticket);
        List<Ticket> selectedTickets = this.chartSpecHandler.selectedTickets();
        if (selectedTickets.size() == 1) {
            this.notifyShowChart();
        }
        this.checkEnabledDrill(this.canDrill());
        this.checkEnabledFilter(this.canFilter());
        this.updateAnalyzeDisplay();
        this.updateTickets();
        this.chartSpecHandler.update();
    }

    public void removeTicket(String label) {
        if (label == null) {
            return;
        }
        this.removeTicket(this.ticket(label));
    }

    public void removeTicket(Ticket ticket) {
        this.chartSpecHandler.removeTicket(ticket);
        this.checkEnabledDrill(this.canDrill());
        this.checkEnabledFilter(this.canFilter());
        this.updateTickets();
        this.updateAnalyzeDisplay();
        this.chartSpecHandler.update();
    }

    public void moveTickets(String[] tickets) {
        this.chartSpecHandler.selectTickets(tickets);
        this.chartSpecHandler.update();
    }

    public void updateScale(String scale) {
        this.updateScale(TimeScale.valueOf((String)scale));
    }

    public void updateScale(TimeScale scale) {
        this.timeScaleHandler.updateScale(scale);
    }

    public UIFile export(final RequestRange range) {
        return new UIFile(){
            private Document document;
            {
                this.document = SumusOlap.this.export(range.from(), range.to());
            }

            public String label() {
                return this.document.name();
            }

            public InputStream content() {
                return this.document.content();
            }
        };
    }

    public void drill(Categorization categorization, List<String> tags) {
        Drill drill = new Drill(categorization, tags);
        this.chartSpecHandler.drill(drill);
        ((SumusOlapNotifier)this.notifier).refreshDrill(DrillBuilder.build(drill));
        this.chartSpecHandler.update();
    }

    public void removeDrillTag(String tagName) {
        Drill drill = this.chartSpecHandler.removeDrillTag(tagName);
        if (drill.tags.size() <= 0) {
            this.removeDrill();
            return;
        }
        ((SumusOlapNotifier)this.notifier).refreshDrill(DrillBuilder.build(drill));
        this.updateActions();
        this.chartSpecHandler.update();
    }

    public void removeDrill() {
        this.chartSpecHandler.drill(null);
        ((SumusOlapNotifier)this.notifier).refreshDrill(null);
        this.chartSpecHandler.update();
    }

    public void selectNameSpace(NameSpace nameSpace) {
        this.children(SumusChart.class).forEach(display -> display.nameSpace(nameSpace));
        if (this.selectedChart != null) {
            this.chartDisplay().ifPresent(AlexandriaDisplay::refresh);
        }
    }

    public void selectChart(ChartOption option) {
        this.selectChart(io.intino.sumus.graph.rules.Chart.valueOf(option.name()), option.option());
    }

    public void selectChart(io.intino.sumus.graph.rules.Chart chart, String option) {
        this.selectedChart = chart;
        ((SumusOlapNotifier)this.notifier).selectChart(chart.toString());
        SumusChart chartDisplay = this.chartDisplay().get();
        if (this.analyzeDisplay().isPresent()) {
            SumusAnalyze display = this.analyzeDisplay().get();
            display.allowTemporalCategorizations(chartDisplay.allowTemporalFiltering());
            display.selectChart(chart);
        }
        if (!chartDisplay.isValidSpecification(this.chartSpecHandler.specification())) {
            ((SumusOlapNotifier)this.notifier).openAnalyzeDialog();
        } else {
            ((SumusOlapNotifier)this.notifier).closeAnalyzeDialog();
        }
        if (chartDisplay.allowDrill()) {
            this.removeDrill();
        } else if (this.chartSpecHandler.drill() != null) {
            this.removeDrill();
        }
        chartDisplay.specification(this.chartSpecHandler.specification());
        this.updateByCategorization();
        this.updateCompare();
    }

    public void updateRange(RequestRange range) {
        this.updateRange(range.from(), range.to());
    }

    public void updateRange(Instant from, Instant to) {
        this.timeScaleHandler.updateRange(from, to);
    }

    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    public void onSelect(Consumer<CatalogInstantBlock> listener) {
        this.selectListeners.add(listener);
    }

    public void removeFilter(String value) {
        this.analyzeDisplay().ifPresent(d -> d.quitFilter(value));
    }

    private List<Catalog> catalogs() {
        if (this.olap.events() == null || this.olap.events().onClickInstant() == null) {
            return Collections.emptyList();
        }
        return this.olap.events().onClickInstant().catalogs();
    }

    protected void init() {
        super.init();
        this.setupOlap();
        this.sendCharts();
        this.sendRanges();
        if (this.olap.select().ticket() != null) {
            this.addTicket(this.olap.select().ticket());
        }
    }

    private void checkZoomsAndTicketsScales(List<Olap.ZoomGroup.Zoom> zooms, List<TimeScale> scales) {
        List ordinalScales = scales.stream().map(Enum::ordinal).collect(Collectors.toList());
        if (zooms.size() != scales.size()) {
            LOG.severe(String.format("Olap %s: The number of scales defined by tickets are different from available zoom levels. It must be the same", this.olap.name$()));
        }
        zooms.forEach(zoom -> {
            if (ordinalScales.contains(zoom.scale().ordinal())) {
                return;
            }
            LOG.severe(String.format("Olap %s: Scale %s not defined by tickets.", this.olap.name$(), zoom.scale().toString()));
        });
    }

    private void drill(List<Drill> drills, boolean includeGlobalSerie) {
        Drill drill = drills.size() > 0 ? drills.get(0) : null;
        this.chartSpecHandler.drill(drill, includeGlobalSerie);
        ((SumusOlapNotifier)this.notifier).refreshDrill(DrillBuilder.build(drill));
        this.chartSpecHandler.update();
    }

    private void checkEnabledDrill(boolean enabled) {
        if (enabled && this.canDrill()) {
            ((SumusOlapNotifier)this.notifier).enableDrill();
        } else {
            ((SumusOlapNotifier)this.notifier).disableDrill();
        }
    }

    private void checkEnabledFilter(boolean enabled) {
        List<Ticket> selectedTickets = this.chartSpecHandler.selectedTickets();
        if (enabled && this.canFilter() && SumusOlap.indicators(selectedTickets).count() > 0L) {
            ((SumusOlapNotifier)this.notifier).enableFilter();
        } else {
            ((SumusOlapNotifier)this.notifier).disableFilter();
        }
    }

    private void updateAnalyzeDisplay() {
        List<Ticket> selectedTickets = this.chartSpecHandler.selectedTickets();
        if (!selectedTickets.isEmpty()) {
            return;
        }
        this.analyzeDisplay().ifPresent(SumusAnalyze::quitFilters);
        this.updateActions();
        if (this.analyzeDisplay().isPresent()) {
            ((SumusOlapNotifier)this.notifier).refreshFilterList(FilterBuilder.buildList(this.analyzeDisplay().get().filterList()));
        }
    }

    private void updateActions() {
        if (this.isFiltering()) {
            ((SumusOlapNotifier)this.notifier).filtering();
            if (this.canDrill()) {
                ((SumusOlapNotifier)this.notifier).enableDrill();
            } else {
                ((SumusOlapNotifier)this.notifier).disableDrill();
            }
        } else if (this.isDrilling()) {
            ((SumusOlapNotifier)this.notifier).drilling();
        } else {
            ((SumusOlapNotifier)this.notifier).notDrilling();
            ((SumusOlapNotifier)this.notifier).notFiltering();
            this.checkEnabledDrill(this.canDrill());
            if (this.canFilter()) {
                ((SumusOlapNotifier)this.notifier).enableFilter();
            } else {
                ((SumusOlapNotifier)this.notifier).disableFilter();
            }
        }
    }

    private void updateCompare() {
        boolean allowDrill;
        if (!this.analyzeDisplay().isPresent()) {
            return;
        }
        SumusAnalyze analyzeDisplay = this.analyzeDisplay().get();
        boolean bl = allowDrill = this.chartDisplay().isPresent() && this.chartDisplay().get().allowDrill();
        if (this.canDrill() && allowDrill) {
            analyzeDisplay.enableComparePanel();
        } else {
            analyzeDisplay.disableComparePanel();
        }
    }

    private void updateTickets() {
        List<Ticket> selectedTickets = this.chartSpecHandler.selectedTickets();
        List<Ticket> ticketList = this.ticketList();
        this.lastSelectedTickets.clear();
        this.lastSelectedTickets.addAll(selectedTickets);
        ((SumusOlapNotifier)this.notifier).ticketList(TicketBuilder.buildList(ticketList));
        ((SumusOlapNotifier)this.notifier).selectTicketList(TicketBuilder.buildList(selectedTickets));
    }

    private void updateByCategorization() {
        if (this.chartSpecHandler.selectedTickets().size() <= 0) {
            return;
        }
        this.chartDisplay().ifPresent(chartDisplay -> {
            Categorization byCategorization = chartDisplay.byCategorization();
            ((SumusOlapNotifier)this.notifier).byCategorization(byCategorization != null ? ReferenceBuilder.build(byCategorization) : null);
        });
    }

    private List<Ticket> ticketList() {
        List<Ticket> selectedTickets = this.chartSpecHandler.selectedTickets();
        return this.olap.tickets().stream().filter((? super T t) -> !selectedTickets.contains(t)).collect(Collectors.toList());
    }

    private void notifyShowChart() {
        if (this.analyzeDisplay().isPresent()) {
            return;
        }
        if (this.olap.charts().size() > 0) {
            this.selectChart(this.olap.charts().get(0), null);
        }
        ((SumusOlapNotifier)this.notifier).scaleList(ScaleBuilder.buildList(this.timeScaleHandler.scales(), this.currentLanguage()));
        this.buildAnalyzeDisplay();
        this.updateScale(this.olap.select().scale().toString());
    }

    private void buildAnalyzeDisplay() {
        SumusAnalyze analyzeDisplay = new SumusAnalyze((SumusBox)this.box);
        analyzeDisplay.timeScaleHandler(this.timeScaleHandler);
        analyzeDisplay.chartSpecHandler(this.chartSpecHandler);
        this.add((AlexandriaDisplay)analyzeDisplay);
        analyzeDisplay.personifyOnce();
        analyzeDisplay.onFilter(this::filter);
        analyzeDisplay.onDrill(this::drill);
        analyzeDisplay.allowTemporalCategorizations(this.chartDisplay().isPresent() && this.chartDisplay().get().allowTemporalFiltering());
        analyzeDisplay.selectChart(this.selectedChart);
        this.updateTemporalCategorizations(this.timeScaleHandler.range());
    }

    private void filter(List<FilterCondition> conditions) {
        this.chartSpecHandler.filter(conditions);
        if (this.analyzeDisplay().isPresent()) {
            ((SumusOlapNotifier)this.notifier).refreshFilterList(FilterBuilder.buildList(this.analyzeDisplay().get().filterList()));
        }
        this.chartSpecHandler.update();
    }

    private void notifyLoading(Boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    private void refreshOlapAndTemporalCategorizations(TimeRange timeRange) {
        this.refreshOlap(timeRange);
        this.updateTemporalCategorizations(timeRange);
    }

    private void refreshOlap(TimeRange timeRange) {
        ((SumusOlapNotifier)this.notifier).updateScale(ScaleBuilder.build(timeRange.scale(), this.currentLanguage()));
        ((SumusOlapNotifier)this.notifier).timeRange(RangeBuilder.build(timeRange));
        this.refresh();
    }

    private void updateTemporalCategorizations(TimeRange timeRange) {
        List<TemporalCategorization> temporalCategorizations = this.temporalCategorizations(timeRange);
        Optional.ofNullable(this.child(SumusAnalyze.class)).ifPresent(ad -> ad.updateTemporalCategorizations(temporalCategorizations));
    }

    private void sendCharts() {
        ((SumusOlapNotifier)this.notifier).chartList(this.olap.charts().stream().map(this::chartOf).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private Chart chartOf(io.intino.sumus.graph.rules.Chart chart) {
        return new Chart().name(chart.toString());
    }

    private void sendRanges() {
        ((SumusOlapNotifier)this.notifier).olapRange(RangeBuilder.build(this.timeScaleHandler.boundsRange()));
        ((SumusOlapNotifier)this.notifier).timeRange(RangeBuilder.build(this.timeScaleHandler.range()));
    }

    private Optional<SumusAnalyze> analyzeDisplay() {
        return Optional.ofNullable(this.child(SumusAnalyze.class));
    }

    private Optional<SumusChart> chartDisplay() {
        return Optional.ofNullable(this.chartDisplay(this.selectedChart));
    }

    private SumusChart chartDisplay(io.intino.sumus.graph.rules.Chart chart) {
        if (chart == null) {
            return null;
        }
        if (!this.chartDisplayMap.containsKey((Object)chart)) {
            this.chartDisplayMap.put(chart, this.chartDisplayBuilders.get((Object)chart).apply(chart));
        }
        return this.chartDisplayMap.get((Object)chart);
    }

    private List<TimeScale> scalesFrom(List<Ticket> tickets) {
        return tickets.stream().map(Ticket::range).flatMap(this::scalesInRange).distinct().sorted().collect(Collectors.toList());
    }

    private Stream<TimeScale> scalesInRange(Ticket.Range range) {
        return IntStream.rangeClosed(range.max().ordinal(), range.min().ordinal()).mapToObj(i -> TimeScale.values()[i]);
    }

    private Document export(Instant from, Instant to) {
        return this.chartDisplay().isPresent() ? this.chartDisplay().get().export(from, to) : null;
    }

    private boolean isFiltering() {
        return this.analyzeDisplay().isPresent() && this.analyzeDisplay().get().filterList().size() <= 0;
    }

    private boolean canFilter() {
        return !this.isDrilling() && this.analyzeDisplay().isPresent() && this.analyzeDisplay().get().filterList().size() > 0;
    }

    private boolean isDrilling() {
        return this.chartSpecHandler.drill() != null;
    }

    private boolean canDrill() {
        List<Ticket> selectedTickets = this.chartSpecHandler.selectedTickets();
        return SumusOlap.indicators(selectedTickets).count() == 1L && this.chartDisplay().isPresent() && !this.chartDisplay().get().isShowingEvents();
    }

    private Ticket ticket(String label) {
        return this.platform().ticketList().stream().filter((? super T b) -> b.label().equals(label)).findFirst().orElse(null);
    }

    private void fillBuilders() {
        this.chartDisplayBuilders.put(io.intino.sumus.graph.rules.Chart.TimeSeriesChart, this::buildTimeSeriesChartDisplay);
        this.chartDisplayBuilders.put(io.intino.sumus.graph.rules.Chart.TimeCrossTable, this::buildTimeCrossTableDisplay);
        this.chartDisplayBuilders.put(io.intino.sumus.graph.rules.Chart.TimeBarChart, this::buildTimeBarChartDisplay);
        this.chartDisplayBuilders.put(io.intino.sumus.graph.rules.Chart.TimeScatterChart, this::buildTimeScatterChartDisplay);
    }

    private SumusChart buildTimeSeriesChartDisplay(io.intino.sumus.graph.rules.Chart chart) {
        SumusTimeSeriesChart display = this.init(new SumusTimeSeriesChart((SumusBox)this.box));
        display.catalogs(this.catalogs());
        this.addAndPersonify(display);
        this.timeScaleHandler.onRangeChange(this::refreshOlapAndTemporalCategorizations);
        this.timeScaleHandler.onScaleChange(this::refreshOlapAndTemporalCategorizations);
        return display;
    }

    private SumusChart buildTimeCrossTableDisplay(io.intino.sumus.graph.rules.Chart chart) {
        SumusTimeCrossTable display = this.addAndPersonify(this.init(new SumusTimeCrossTable((SumusBox)this.box)));
        this.updateTemporalCategorizations(this.timeScaleHandler.range());
        return display;
    }

    private SumusTimeBarChart buildTimeBarChartDisplay(io.intino.sumus.graph.rules.Chart chart) {
        return this.addAndPersonify(this.init(new SumusTimeBarChart((SumusBox)this.box)));
    }

    private SumusTimeScatterChart buildTimeScatterChartDisplay(io.intino.sumus.graph.rules.Chart chart) {
        return this.addAndPersonify(this.init(new SumusTimeScatterChart((SumusBox)this.box)));
    }

    private <D extends SumusChart> D init(D display) {
        display.timeScaleHandler(this.timeScaleHandler);
        display.chartSpecHandler(this.chartSpecHandler);
        display.nameSpace(this.nameSpaceHandler.selectedNameSpace(this.session()));
        display.instantFormatter(this.olap.instantFormatter());
        display.onShowDialog(value -> ((SumusOlapNotifier)this.notifier).openAnalyzeDialog());
        display.onSelect(instant -> this.notifySelectInstant((CatalogInstantBlock)instant));
        display.onLoading(value -> this.notifyLoading((Boolean)value));
        return display;
    }

    private <D extends SumusChart> D addAndPersonify(D display) {
        this.add((AlexandriaDisplay)display);
        display.personifyOnce();
        return display;
    }

    private void notifySelectInstant(CatalogInstantBlock instant) {
        this.selectListeners.forEach(l -> l.accept(instant));
    }

    private List<Categorization> categorizations() {
        List<Cube> cubes = this.cubes();
        return ((SumusBox)this.box).graph().categorizationList().stream().filter((? super T cat) -> cubes.stream().anyMatch(cube -> cat.digestTagger((Cube)((Object)((Object)cube))) != null)).collect(Collectors.toList());
    }

    private List<Cube> cubes() {
        List tickets = this.chartSpecHandler != null && this.chartSpecHandler.selectedTickets().size() > 0 ? this.chartSpecHandler.selectedTickets() : Collections.emptyList();
        return tickets.stream().map(ticket -> ticket.core$().findNode(MeasureIndicator.Formula.class)).map(formulas -> formulas.stream().map(MeasureIndicator.Formula::cube).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<TemporalCategorization> temporalCategorizations(TimeRange range) {
        List<TimeScale> timeScales = this.scalesFrom(this.olap.tickets());
        return timeScales.stream().map(scale -> this.temporalCategorization(this.rangeForScale(range, (TimeScale)scale))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private TimeRange rangeForScale(TimeRange range, TimeScale scale) {
        TimeScale rangeScale = range.scale();
        if (scale.ordinal() <= rangeScale.ordinal()) {
            return new TimeRange(range.from(), range.to(), scale);
        }
        Instant instant = rangeScale.addTo(range.to(), 1L);
        instant = rangeScale.next().addTo(instant, -1L);
        return new TimeRange(range.from(), instant, scale);
    }

    private List<TemporalCategorization> temporalCategorization(TimeRange range) {
        TemporalCategorization result = new TemporalCategorizationFactory().get(range);
        result.helper(((SumusBox)this.box).translatorHelper()).language(this.currentLanguage());
        return Collections.singletonList(result);
    }

    private TimeScaleHandler buildTimeScaleHandler(Olap olap, List<Olap.ZoomGroup.Zoom> zooms, List<TimeScale> scales) {
        TimeScaleHandler.Bounds bounds = new TimeScaleHandler.Bounds();
        String username = this.user() != null ? this.user().username() : this.session().id();
        bounds.rangeLoader(() -> {
            Olap.Range range = olap.range();
            return new TimeRange(range.from(username), range.to(username), TimeScale.Minute);
        });
        bounds.mode(olap.select().range() == Mode.FromTheBeginning ? Bounds.Mode.FromTheBeginning : Bounds.Mode.ToTheLast);
        bounds.zooms(zooms.stream().filter((? super T zoom) -> scales.contains(this.scaleOf(zoom.scale()))).collect(Collectors.toMap(zoom -> this.scaleOf(zoom.scale()), zoom -> new Bounds.Zoom((Olap.ZoomGroup.Zoom)((Object)zoom)){
            final /* synthetic */ Olap.ZoomGroup.Zoom val$zoom;
            {
                this.val$zoom = zoom;
            }

            public int min() {
                return this.val$zoom.instantRange().min();
            }

            public int max() {
                return this.val$zoom.instantRange().max();
            }
        })));
        TimeScaleHandler timeScaleHandler = new TimeScaleHandler(bounds, scales, this.scaleOf(olap.select().scale()));
        timeScaleHandler.availableScales(timeScaleHandler.scales());
        timeScaleHandler.onRangeChange(r -> this.chartSpecHandler.range((TimeRange)r));
        timeScaleHandler.onNotValidRange(r -> this.chartSpecHandler.range((TimeRange)r));
        timeScaleHandler.onScaleChange(r -> this.chartSpecHandler.range((TimeRange)r));
        return timeScaleHandler;
    }

    private ChartSpecHandler buildChartSpecHandler() {
        ChartSpecHandler result = new ChartSpecHandler();
        result.olapTickets(this.olap.tickets());
        result.olapCategorizationsLoader(new ChartSpecHandler.CategorizationsLoader(){

            @Override
            public List<Categorization> categorizations() {
                return SumusOlap.this.categorizations();
            }

            @Override
            public List<TemporalCategorization> temporalCategorizations() {
                return SumusOlap.this.temporalCategorizations(SumusOlap.this.timeScaleHandler.range());
            }
        });
        result.onChange(this::refreshSelectedChartDesign);
        return result;
    }

    private void refreshSelectedChartDesign(ChartSpec chartSpec) {
        if (this.selectedChart == null) {
            return;
        }
        if (!chartSpec.equalsTickets(this.lastSelectedTickets)) {
            this.updateTickets();
        }
        this.updateByCategorization();
        this.chartDisplay().ifPresent(d -> {
            if (!d.isValidSpecification(chartSpec)) {
                ((SumusOlapNotifier)this.notifier).openAnalyzeDialog();
            }
            d.specification(chartSpec);
        });
    }

    private void setupOlap() {
        List<Olap.ZoomGroup.Zoom> zooms = this.olap.zoomGroup() != null ? this.olap.zoomGroup().zoomList() : Collections.emptyList();
        List<TimeScale> scales = this.scalesFrom(this.olap.tickets());
        this.checkZoomsAndTicketsScales(zooms, scales);
        if (!scales.contains(this.scaleOf(this.olap.select().scale()))) {
            LOG.severe(String.format("Olap %s: Select scale %s not available", this.olap.name$(), this.olap.select().scale().toString()));
        }
        this.timeScaleHandler = this.buildTimeScaleHandler(this.olap, zooms, scales);
        this.chartSpecHandler = this.buildChartSpecHandler();
        this.olap.onRefresh(() -> {
            this.sendRanges();
            this.chartDisplay().ifPresent(AlexandriaDisplay::refresh);
        });
    }
}

