/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.builders.NameSpaceBuilder;
import io.intino.sumus.box.displays.notifiers.SumusNameSpaceNotifier;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.helpers.NameSpaceHandler;
import java.util.List;

public class SumusNameSpace
extends SumusDisplay<SumusNameSpaceNotifier> {
    private NameSpaceHandler nameSpaceHandler;

    public SumusNameSpace(SumusBox box) {
        super(box);
        this.nameSpaceHandler = new NameSpaceHandler(box.graph());
    }

    public SumusNameSpace nameSpaceHandler(NameSpaceHandler handler) {
        this.nameSpaceHandler = handler;
        return this;
    }

    protected void init() {
        super.init();
        this.sendNameSpaceList();
    }

    private void sendNameSpaceList() {
        this.refreshNameSpaces(this.nameSpaceHandler.nameSpaces(this.user()));
        this.refreshSelectedNameSpace(this.nameSpaceHandler.selectedNameSpace(this.session()));
    }

    private void refreshNameSpaces(List<NameSpace> nameSpaces) {
        ((SumusNameSpaceNotifier)this.notifier).refreshNameSpaces(NameSpaceBuilder.buildList(nameSpaces));
    }

    private void refreshSelectedNameSpace(NameSpace nameSpace) {
        ((SumusNameSpaceNotifier)this.notifier).refreshSelectedNameSpace(NameSpaceBuilder.build(nameSpace));
    }

    public void selectNameSpace(String value) {
        this.nameSpaceHandler.select(this.session(), value);
    }
}

