/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.alexandria.ui.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.ui.displays.AlexandriaDisplayNotifier;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusCategorization;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.graph.Categorization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class SumusCategorizationContainer<DN extends AlexandriaDisplayNotifier>
extends SumusDisplay<DN> {
    private List<Categorization> categorizationList = new ArrayList<Categorization>();
    private List<TemporalCategorization> temporalCategorizationList = new ArrayList<TemporalCategorization>();
    private final Map<String, SumusCategorization> displayByCategorization = new HashMap<String, SumusCategorization>();
    private List<TemporalCategorization> activeCategorizations = new ArrayList<TemporalCategorization>();

    public SumusCategorizationContainer(SumusBox box) {
        super(box);
    }

    public void categorizations(List<Categorization> categorizations) {
        this.categorizationList = categorizations;
    }

    public void temporalCategorizations(List<TemporalCategorization> categorizations) {
        this.temporalCategorizationList = categorizations;
    }

    public void updateTemporalCategorizations(List<TemporalCategorization> activeCategorizations) {
        this.activeCategorizations = activeCategorizations;
        this.sendRefreshTemporalCategorizationList(this.temporalCategorizations());
    }

    protected void init() {
        super.init();
        this.sendRefreshCategorizationList(this.categorizationList);
        this.sendRefreshTemporalCategorizationList(this.temporalCategorizationList);
        this.categorizationList.forEach(this::createCategorizationDisplay);
        this.temporalCategorizationList.forEach(this::createCategorizationDisplay);
    }

    protected abstract void sendRefreshCategorizationList(List<Categorization> var1);

    protected abstract void sendRefreshTemporalCategorizationList(List<TemporalCategorization> var1);

    protected abstract void addListeners(SumusCategorization var1);

    protected Collection<SumusCategorization> categorizationDisplays() {
        return this.displayByCategorization.values();
    }

    protected SumusCategorization categorizationDisplay(String name) {
        return this.displayByCategorization.get(name);
    }

    private List<TemporalCategorization> temporalCategorizations() {
        if (this.activeCategorizations.isEmpty()) {
            return this.temporalCategorizationList;
        }
        return this.activeCategorizations.stream().map(c -> c).collect(Collectors.toList());
    }

    private void createCategorizationDisplay(Categorization categorization) {
        SumusCategorization display = new SumusCategorization((SumusBox)this.box);
        display.categorization(categorization);
        this.displayByCategorization.put(categorization.name$(), display);
        this.add((AlexandriaDisplay)display);
        this.addListeners(display);
        display.personifyOnce(categorization.name$());
        display.refresh();
    }
}

