/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.ui.model.Catalog;
import io.intino.konos.alexandria.ui.model.Item;
import io.intino.konos.alexandria.ui.model.TimeRange;
import io.intino.konos.alexandria.ui.model.catalog.arrangement.Group;
import io.intino.konos.alexandria.ui.services.push.UISession;
import io.intino.sumus.QueryEngine;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.graph.AbstractAccess;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.TagMap;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.helpers.NameSpaceHandler;
import io.intino.sumus.queries.EntityQuery;
import io.intino.sumus.queries.Filter;
import io.intino.sumus.queries.Scope;
import io.intino.sumus.queries.TemporalRecordQuery;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SumusDisplayHelper {
    private static Map<String, QueryEngine> queryEngineMap = new HashMap<String, QueryEngine>();
    private static NameSpaceHandler nameSpaceHandler;

    public static QueryEngine queryEngine(SumusBox box, UISession session) {
        String id = session.id();
        if (!queryEngineMap.containsKey(id)) {
            queryEngineMap.put(id, new QueryEngine(box));
        }
        return queryEngineMap.get(id);
    }

    public static SumusBox sumusBox(Box box) {
        return (SumusBox)box.owner();
    }

    public static NameSpaceHandler nameSpaceHandler(SumusBox box) {
        if (nameSpaceHandler == null) {
            nameSpaceHandler = new NameSpaceHandler(box.graph());
        }
        return nameSpaceHandler;
    }

    public static Scope scopeOf(io.intino.konos.alexandria.ui.model.catalog.Scope scope) {
        if (scope == null) {
            return null;
        }
        return new Scope().tags(SumusDisplayHelper.tags(scope.groups())).records(SumusDisplayHelper.records(scope.objects()));
    }

    public static List<AbstractAccess> accesses(SumusBox box, UISession session) {
        return ((SumusGraph)box.graph().core$().as(SumusGraph.class)).accesses(session.user());
    }

    public static Catalog.ArrangementFilterer createArrangementFilterer(final SumusBox box, final UISession session) {
        return new Catalog.ArrangementFilterer(){
            public List<String> groupings = new ArrayList<String>();
            Filter filter = null;

            public UISession session() {
                return session;
            }

            public void add(String grouping, Group ... groups) {
                this.groupings.add(grouping);
                this.filter = this.isEmpty() ? new Filter() : this.filter;
                List<String> tags = SumusDisplayHelper.tags(groups);
                this.filter.addTags(tags);
            }

            public boolean contains(Item item) {
                if (item == null) {
                    return false;
                }
                return this.filter.contains(this.groupings.stream().map(g -> this.categorization((String)g).categorizedLayersMap(Collections.singletonList(item.object())).keySet()).flatMap(Collection::stream).collect(Collectors.toList()));
            }

            private Categorization categorization(String grouping) {
                return (Categorization)((Object)box.graph().categorizationList(c -> c.name$().equals(grouping)).collect(Collectors.toList()).get(0));
            }

            public void clear() {
                this.filter = null;
                this.groupings.clear();
            }

            public boolean isEmpty() {
                return this.filter == null;
            }
        };
    }

    private static Map<String, List<String>> tags(Map<String, List<Group>> groups) {
        return groups.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SumusDisplayHelper.tags((List)e.getValue())));
    }

    public static List<String> tags(Group ... groups) {
        return SumusDisplayHelper.tags(Stream.of(groups));
    }

    public static List<String> tags(List<Group> groups) {
        return SumusDisplayHelper.tags(groups.stream());
    }

    public static String tag(Group group) {
        return group.label();
    }

    public static List<Group> groups(SumusBox box, Categorization categorization, List<? extends Layer> items, UISession session) {
        return SumusDisplayHelper.groups(categorization.filter(categorization.categorizedLayersMap(items), new LinkedHashSet<String>(categorization.tags(SumusDisplayHelper.accesses(box, session)))));
    }

    public static Group group(String tag, int count) {
        return new Group().label(tag).countObjects(count);
    }

    public static void createGroup(SumusBox box, Catalog catalog, String grouping, Group group, String username) {
    }

    private static List<String> tags(Stream<Group> groups) {
        return groups.map(SumusDisplayHelper::tag).collect(Collectors.toList());
    }

    private static Map<String, List<Record>> records(Map<String, List<Object>> objects) {
        return objects.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SumusDisplayHelper.objectsToRecords((List)e.getValue())));
    }

    private static List<String> objectsToRecordsIds(List<Object> objects) {
        return objects.stream().map(o -> ((Layer)o).core$().id()).collect(Collectors.toList());
    }

    private static List<Record> objectsToRecords(List<Object> objects) {
        return objects.stream().map(o -> (Record)((Layer)o).core$().as(Record.class)).collect(Collectors.toList());
    }

    private static List<Entity> objectsToEntities(List<Object> objects) {
        return objects.stream().map(o -> (Entity)((Layer)o).core$().as(Entity.class)).collect(Collectors.toList());
    }

    private static List<Record> layersToRecords(List<? extends Layer> objects) {
        return objects.stream().map(o -> (Record)o.a$(Record.class)).collect(Collectors.toList());
    }

    public static <T extends Layer> List<T> entities(SumusBox box, Class<T> entityClass, io.intino.konos.alexandria.ui.model.catalog.Scope scope, String condition, UISession session) {
        Concept concept = box.graph().core$().concept(entityClass);
        EntityQuery.Builder builder = new EntityQuery.Builder();
        builder.scope(SumusDisplayHelper.scopeOf(scope));
        builder.condition(condition);
        return SumusDisplayHelper.queryEngine(box, session).entities(builder.build(concept, session.user())).stream().map(e -> e.a$(entityClass)).collect(Collectors.toList());
    }

    public static <T extends Layer> T entity(SumusBox box, Class<T> entityClass, String id, UISession session) {
        Entity entity = SumusDisplayHelper.queryEngine(box, session).entity(id, session.user());
        return (T)(entity != null ? entity.a$(entityClass) : null);
    }

    public static <T extends Layer> List<T> temporalRecords(SumusBox box, Class<T> temporalRecordClass, io.intino.konos.alexandria.ui.model.catalog.Scope scope, String condition, TimeRange timeRange, NameSpace nameSpace, UISession session) {
        Concept concept = box.graph().core$().concept(temporalRecordClass);
        TemporalRecordQuery.Builder builder = new TemporalRecordQuery.Builder();
        builder.scope(SumusDisplayHelper.scopeOf(scope));
        builder.condition(condition);
        builder.timeRange(timeRange);
        builder.nameSpace(nameSpace);
        return SumusDisplayHelper.queryEngine(box, session).temporalRecords(builder.build(concept, session.user())).stream().map(r -> r.a$(temporalRecordClass)).collect(Collectors.toList());
    }

    public static <T extends Layer> T temporalRecord(SumusBox box, Class<T> temporalRecordClass, String id, UISession session) {
        TemporalRecord temporalRecord = SumusDisplayHelper.queryEngine(box, session).temporalRecord(id, session.user());
        return (T)(temporalRecord != null ? temporalRecord.a$(temporalRecordClass) : null);
    }

    private static List<Group> groups(TagMap tagMap) {
        return tagMap.entrySet().stream().map(e -> SumusDisplayHelper.group((String)e.getKey(), ((List)e.getValue()).size())).collect(Collectors.toList());
    }
}

