/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.viewmodels;

import io.intino.sumus.analytics.Scaler;
import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.StackedIndicator;
import io.intino.sumus.graph.Ticket;
import io.intino.tara.magritte.Node;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Serie {
    private final Map<Instant, Double> values = new ConcurrentHashMap<Instant, Double>();
    private final MeasureIndicator indicator;
    private final String label;
    private final Ticket.Style style;
    private final Ticket.DecimalPlaces decimalPlaces;
    private final Ticket.Min min;
    private final Ticket.Max max;
    private Scaler scaler;
    private String color;
    private boolean asGlobalSerie = false;
    private Double minValue = null;
    private Double maxValue = null;

    public Serie(Ticket ticket, MeasureIndicator indicator, String label, String color) {
        this.indicator = indicator;
        this.style = ticket.style();
        this.label = label;
        this.decimalPlaces = ticket.decimalPlaces();
        this.min = ticket.min();
        this.max = ticket.max();
        this.color = color;
    }

    public String label() {
        return this.label;
    }

    public String color() {
        return this.color;
    }

    public String style() {
        if (this.asGlobalSerie) {
            return Ticket.Style.Line.Dotted.name().toLowerCase();
        }
        if (this.style.stacked() == Ticket.Style.Stacked.None) {
            return this.style.line().name().toLowerCase();
        }
        return this.style.stacked().name().toLowerCase();
    }

    public Serie asGlobalSerie() {
        this.asGlobalSerie = true;
        return this;
    }

    public Ticket.Min min() {
        return this.min;
    }

    public Ticket.Max max() {
        return this.max;
    }

    public AbstractMetric.Unit unit() {
        return this.indicator.unit();
    }

    public Ticket.DecimalPlaces decimalPlaces() {
        return this.decimalPlaces;
    }

    public void scaleValues(Scaler scaler) {
        this.scaler = scaler;
        this.values.entrySet().forEach(e -> e.setValue(scaler.scale((Double)e.getValue())));
    }

    public double maxValue() {
        return this.maxValue != null ? this.maxValue : -1.0;
    }

    public double minValue() {
        return this.minValue;
    }

    public String group() {
        Node owner = this.indicator.core$().owner();
        if (owner.is(StackedIndicator.class)) {
            return ((Ticket)owner.owner().as(Ticket.class)).label();
        }
        return ((Ticket)owner.as(Ticket.class)).label();
    }

    public Map<Instant, Double> values() {
        return this.values;
    }

    public String metric() {
        return this.scaler.unitLabel();
    }

    public void register(Instant time, Double value) {
        if (this.minValue == null || this.minValue > value) {
            this.minValue = value;
        }
        if (this.maxValue == null || this.maxValue < value) {
            this.maxValue = value;
        }
        this.values.put(time, value);
    }
}

