/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.exporters;

import io.intino.sumus.QueryEngine;
import io.intino.sumus.analytics.exporters.AbstractDocument;
import io.intino.sumus.graph.Categorization;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxDocument
extends AbstractDocument {
    private final XSSFWorkbook workbook = new XSSFWorkbook();
    private final List<QueryEngine.DocumentRow> rows;
    private final String name;
    private final XSSFCellStyle headerCellStyle;

    public XlsxDocument(List<QueryEngine.DocumentRow> rows, String language) {
        super(language);
        this.rows = rows;
        this.name = "Analysis-" + FORMATTER.format(Instant.now(Clock.systemUTC())) + ".xlsx";
        this.headerCellStyle = this.headerCellStyle();
        this.buildDocument();
    }

    public static XlsxDocument export(List<QueryEngine.DocumentRow> rows, String language) {
        return new XlsxDocument(rows, language);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public InputStream content() {
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            this.workbook.write((OutputStream)result);
            return new ByteArrayInputStream(result.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public File write(File directory) {
        return this.write(directory, this.name);
    }

    @Override
    public File write(File directory, String name) {
        File file = new File(directory, name);
        try (FileOutputStream stream = new FileOutputStream(file);){
            this.workbook.write((OutputStream)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    private void buildDocument() {
        XSSFSheet sheet = this.workbook.createSheet();
        this.writeHeaders((Row)sheet.createRow(0));
        this.writeValues(sheet);
        IntStream.rangeClosed(0, sheet.getRow(sheet.getFirstRowNum()).getLastCellNum()).forEach(arg_0 -> ((XSSFSheet)sheet).autoSizeColumn(arg_0));
    }

    private void writeHeaders(Row row) {
        this.writeHeader(row, this.translate("Time"));
        this.writeHeader(row, this.translate("Indicator"));
        if (this.rows.size() > 0) {
            this.writeDrillAndFilterHeaders(row, this.rows.get(0));
        }
        this.writeHeader(row, this.translate("Value"));
    }

    private void writeDrillAndFilterHeaders(Row row, QueryEngine.DocumentRow documentRow) {
        documentRow.drill.entrySet().forEach(e -> {
            this.writeHeader(row, this.translate("DrillCategorization"));
            this.writeHeader(row, this.translate("DrillTag"));
        });
        documentRow.filter.entrySet().forEach(e -> {
            this.writeHeader(row, this.translate("FilterCategorization"));
            ((List)e.getValue()).forEach(entry -> this.writeHeader(row, this.translate("FilterTag")));
        });
    }

    private XSSFCellStyle headerCellStyle() {
        XSSFCellStyle style = this.workbook.createCellStyle();
        XSSFFont font = this.workbook.createFont();
        font.setBoldweight((short)700);
        style.setFont((Font)font);
        return style;
    }

    private void writeHeader(Row row, String label) {
        Cell cell = row.createCell((int)(row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum()));
        cell.setCellValue(label);
        cell.setCellStyle((CellStyle)this.headerCellStyle);
    }

    private void writeValues(XSSFSheet sheet) {
        this.indicatorsToListOfObjectsArray().forEach(values -> {
            XSSFRow row = sheet.createRow(sheet.getLastRowNum() + 1);
            for (Object value : values) {
                this.writeCell(value, row.createCell(Math.max(row.getLastCellNum(), 0)));
            }
        });
    }

    private void writeCell(Object value, Cell cell) {
        if (value instanceof String) {
            cell.setCellValue((String)value);
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        }
    }

    private Stream<Object[]> indicatorsToListOfObjectsArray() {
        return this.rows.stream().map(XlsxDocument::toObjectArray);
    }

    private static Object[] toObjectArray(QueryEngine.DocumentRow row) {
        ArrayList<String> objects = new ArrayList<String>();
        objects.add(row.instant);
        objects.add(row.indicator);
        row.drill.entrySet().forEach(e -> {
            objects.add(((Categorization)((Object)((Object)e.getKey()))).label());
            objects.add((String)e.getValue());
        });
        row.filter.entrySet().forEach(e -> {
            objects.add(((Categorization)((Object)((Object)e.getKey()))).label());
            objects.addAll((Collection)e.getValue());
        });
        objects.add(row.value == null ? "" : row.value + " " + row.unitLabel);
        return objects.toArray();
    }
}

