/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.exporters;

import io.intino.sumus.QueryEngine;
import io.intino.sumus.analytics.exporters.AbstractDocument;
import io.intino.sumus.graph.Categorization;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

public class CsvDocument
extends AbstractDocument {
    private final List<QueryEngine.DocumentRow> rows;
    private final String name;
    private final String csv;

    private CsvDocument(List<QueryEngine.DocumentRow> rows, String language) {
        super(language);
        this.rows = rows;
        this.name = "Analysis-" + FORMATTER.format(Instant.now(Clock.systemUTC())) + ".csv";
        this.csv = this.buildDocument();
    }

    public static CsvDocument export(List<QueryEngine.DocumentRow> rows, String language) {
        return new CsvDocument(rows, language);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public InputStream content() {
        return new ByteArrayInputStream(this.csv.getBytes());
    }

    @Override
    public File write(File directory) {
        return this.write(directory, this.name);
    }

    @Override
    public File write(File directory, String name) {
        File file = new File(directory, name);
        try {
            Files.write(file.toPath(), this.csv.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public void write(HttpServletResponse response) {
        this.write(response, this.name);
    }

    private void write(HttpServletResponse response, String name) {
        try {
            response.setContentType("text/csv");
            response.setHeader("Content-Disposition", "attachment;filename=" + name);
            response.getOutputStream().write(this.csv.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String buildDocument() {
        StringBuilder csv = this.createHeader().append("\n");
        this.rows.forEach(row -> this.appendRow(csv, (QueryEngine.DocumentRow)row));
        return csv.toString();
    }

    private StringBuilder createHeader() {
        return new StringBuilder(this.translate("Time")).append(";").append(this.translate("Ticket")).append(";").append(this.drillHeader(this.rows)).append(this.filterHeader(this.rows)).append(this.translate("Value")).append("\n");
    }

    private String drillHeader(List<QueryEngine.DocumentRow> rows) {
        if (rows.size() == 0) {
            return "";
        }
        return rows.get((int)0).drill.entrySet().stream().map(e -> this.translate("DrillCategorization") + ";" + this.translate("DrillTag") + ";").collect(Collectors.joining(""));
    }

    private String filterHeader(List<QueryEngine.DocumentRow> rows) {
        if (rows.size() == 0) {
            return "";
        }
        return rows.get((int)0).filter.entrySet().stream().map(e -> {
            StringBuilder builder = new StringBuilder(this.translate("FilterCategorization") + ";");
            ((List)e.getValue()).forEach(l -> builder.append(this.translate("FilterTag")).append(";"));
            return builder.toString();
        }).collect(Collectors.joining(""));
    }

    private StringBuilder appendRow(StringBuilder csv, QueryEngine.DocumentRow row) {
        return csv.append(row.instant).append(";").append(row.indicator).append(";").append(this.drill(row.drill)).append(this.filter(row.filter)).append(row.value == null ? "" : row.value + " " + row.unitLabel).append("\n");
    }

    private String drill(Map<Categorization, String> drill) {
        StringBuilder builder = new StringBuilder();
        drill.entrySet().forEach(e -> builder.append(((Categorization)((Object)((Object)e.getKey()))).label()).append(";").append(e.getKey()));
        return builder.length() == 0 ? "" : builder.append(";").toString();
    }

    private String filter(Map<Categorization, List<String>> filter) {
        StringBuilder builder = new StringBuilder();
        filter.forEach((key, value) -> {
            builder.append(key.label()).append(";");
            value.forEach(l -> builder.append((String)l).append(";"));
        });
        return builder.toString();
    }
}

