/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus;

import io.intino.konos.alexandria.ui.model.TimeRange;
import io.intino.konos.alexandria.ui.model.TimeScale;
import io.intino.konos.alexandria.ui.services.push.User;
import io.intino.sumus.analytics.viewmodels.CrossTable;
import io.intino.sumus.analytics.viewmodels.Histogram;
import io.intino.sumus.analytics.viewmodels.Serie;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.helpers.CrossTableHelper;
import io.intino.sumus.helpers.EntityHelper;
import io.intino.sumus.helpers.ExportDocumentHelper;
import io.intino.sumus.helpers.HistogramHelper;
import io.intino.sumus.helpers.RecordHelper;
import io.intino.sumus.helpers.TemporalRecordHelper;
import io.intino.sumus.helpers.TimeSeriesHelper;
import io.intino.sumus.queries.CrossTableQuery;
import io.intino.sumus.queries.EntityQuery;
import io.intino.sumus.queries.HistogramQuery;
import io.intino.sumus.queries.Scope;
import io.intino.sumus.queries.TemporalRecordQuery;
import io.intino.sumus.queries.TimeSeriesQuery;
import java.time.Instant;
import java.util.List;
import java.util.Map;

public class QueryEngine {
    private final SumusBox box;
    private Scope scope = null;

    public QueryEngine(SumusBox box) {
        this.box = box;
    }

    public List<Serie> timeSeries(TimeSeriesQuery query) {
        return new TimeSeriesHelper().execute(query);
    }

    public List<DocumentRow> document(TimeSeriesQuery query) {
        return new ExportDocumentHelper().execute(query);
    }

    public CrossTable crossTable(CrossTableQuery query) {
        return new CrossTableHelper().execute(query);
    }

    public Histogram histogram(HistogramQuery query) {
        return new HistogramHelper().execute(query);
    }

    public List<Entity> entities(EntityQuery query) {
        return new EntityHelper(this.box).entities(query);
    }

    public List<String> entities(TimeSeriesQuery query) {
        return new TimeSeriesHelper().entities(query);
    }

    public Entity entity(String id, User user) {
        return new EntityHelper(this.box).entity(id, user);
    }

    public TimeRange temporalRecordRange(List<NameSpace> nameSpaces) {
        return new TemporalRecordHelper(this.box).recordRange(nameSpaces);
    }

    public List<TemporalRecord> temporalRecords(TemporalRecordQuery query) {
        return new TemporalRecordHelper(this.box).records(query);
    }

    public TemporalRecord temporalRecord(String id, User user) {
        return new TemporalRecordHelper(this.box).record(id, user);
    }

    public Record record(String id, User user) {
        return new RecordHelper(this.box).record(id, user);
    }

    public static class DocumentRow {
        public final Instant internalInstant;
        public final String instant;
        public final String indicator;
        public final Map<Categorization, String> drill;
        public final Map<Categorization, List<String>> filter;
        public final Double value;
        public final String unitLabel;

        public DocumentRow(Instant instant, String indicator, Map<Categorization, String> drill, Map<Categorization, List<String>> filter, Double value, String unitLabel, TimeScale scale) {
            this.internalInstant = instant;
            this.instant = scale.toString(instant);
            this.indicator = indicator;
            this.drill = drill;
            this.filter = filter;
            this.value = value;
            this.unitLabel = unitLabel;
        }
    }
}

