package io.intino.sumus.queries;

import io.intino.sumus.TimeStamp;

import java.util.*;

import static java.util.Collections.singletonList;

public class Filter {

	private final List<Set<String>> tags = new ArrayList<>();
	private final Set<TimeStamp> timeStamps = new HashSet<>();

	public void addTags(List<String> tags) {
		this.tags.add(new HashSet<>(tags));
	}

	public void addTimeStamp(TimeStamp timeStamps) {
		this.timeStamps.add(timeStamps);
	}

	public boolean contains(Collection<String> tags) {
		for (Set<String> items : this.tags) if (!containsAnyOf(tags, items)) return false;
		return true;
	}

	public boolean contains(String id) {
		return contains(singletonList(id));
	}

	private boolean containsAnyOf(Collection<String> tags, Set<String> items) {
		for (String tag : tags) if (items.contains(tag)) return true;
		return false;
	}

	public boolean isTemporal() {
		return !timeStamps.isEmpty();
	}

	public boolean contains(TimeStamp timeStamp) {
		return timeStamps.contains(timeStamp);
	}
}
