package io.intino.sumus.datawarehouse.store;

import io.intino.sumus.TimeStamp;
import io.intino.sumus.graph.Cube;

import java.time.Instant;
import java.util.List;

public interface Digest {

	Cube cube();

	List<String> dimensionIds(String dimension);

	String dimensionIds();

	List<String> dimensionIdsSplit();

	String ref();

	int intOf(String col);

	float floatOf(String col);

	void set(String dimension, String value);

	void add(String dimension, String value);

	void set(String col, int value);

	void set(String col, float value);

	void add(String col, int value);

	void add(String col, float value);

	TimeStamp ts();

	void save();
}
