package io.intino.sumus.datawarehouse;

import io.intino.konos.alexandria.ui.model.TimeScale;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.datawarehouse.store.Bucket;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.NameSpace;

import java.time.Instant;

import static io.intino.sumus.datawarehouse.store.Bucket.KEY_SEPARATOR;
import static io.intino.sumus.datawarehouse.store.Bucket.REF_SEPARATOR;

public class Data {
	public static Bucket getBucket(Cube self, NameSpace nameSpace, TimeScale scale, Instant instant) {
		Bucket bucket = Bucket.get(self, nameSpace, new TimeStamp(instant, scale));
		return bucket.exists() ? bucket : null;
	}

	public static Bucket newBucket(Cube self, NameSpace nameSpace, TimeScale scale, Instant instant) {
		return Bucket.get(self, nameSpace, new TimeStamp(instant, scale)).create();
	}

	public static Digest getDigest(Cube self, String digestRef) {
		String[] split = digestRef.split(REF_SEPARATOR);
		NameSpace nameSpace = self.core$().graph().load(split[0]).as(NameSpace.class);
		TimeStamp timeStamp = new TimeStamp(Instant.parse(split[1]), TimeScale.valueOf(split[2]));
		Bucket bucket = Bucket.get(self, nameSpace, timeStamp);
		return bucket.exists() ? bucket.digest(split[3].split("\\" + KEY_SEPARATOR)) : null;
	}
}