package io.intino.sumus.box.resources;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.actions.AnalyticsPageAction;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;

import java.util.Base64;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class AnalyticsPageResource extends io.intino.konos.alexandria.ui.spark.resources.Resource {
	private final SumusBox box;

	public AnalyticsPageResource(SumusBox box, io.intino.konos.alexandria.ui.spark.UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
		this.box = box;
	}

	@Override
	public void execute() throws AlexandriaException {
		super.execute();
		fillDeviceParameter();
		render();
	}

	private void render() {
		String clientId = UUID.randomUUID().toString();
		AnalyticsPageAction action = new AnalyticsPageAction();
		action.session = manager.currentSession();
		action.session.whenLogin(new Function<String, String>() {
			@Override
			public String apply(String baseUrl) {
				return AnalyticsPageResource.this.authenticate(baseUrl);
			}
		});
		action.session.whenLogout(b -> logout());
		action.box = box;
		action.clientId = clientId;

		action.device = parameterValue("device");
		action.token = parameterValue("token");

		manager.pushService().onOpen(client -> {
			if (!client.id().equals(action.clientId))
				return false;

			if (client.soul() != null)
				return false;

			io.intino.konos.alexandria.ui.displays.Soul soul = action.prepareSoul(client);
			soul.onRedirect((location) -> manager.redirect(location));
			soul.addRegisterDisplayListener(display -> {
				display.inject(notifier(action.session, client, display));
				display.inject(action.session);
				display.inject(soul);
				display.inject(() -> soul);
			});
			client.soul(soul);

			box.registerSoul(clientId, soul);

			return true;
		});

		manager.pushService().onClose(clientId).execute(new Consumer<io.intino.konos.alexandria.ui.services.push.UIClient>() {
			@Override
			public void accept(io.intino.konos.alexandria.ui.services.push.UIClient client) {
				box.soul(client.id()).ifPresent(s -> s.destroy());
				box.unRegisterSoul(client.id());
				manager.unRegister(client);
			}
		});

		manager.write(action.execute());
	}

}