package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.SumusTimeSeriesChart;
import io.intino.konos.alexandria.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.SumusTimeSeriesChartNotifier;
import io.intino.konos.alexandria.ui.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.ui.spark.UISparkManager;

public class SumusTimeSeriesChartRequester extends AlexandriaDisplayRequester {

	public SumusTimeSeriesChartRequester(UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SumusTimeSeriesChart display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("updateRangeAndScale")) {
			display.updateRangeAndScale(manager.fromQuery("value", io.intino.sumus.box.schemas.RequestRange.class));
			return;
		}
		else if (operation.equals("moveLeft")) {
			display.moveLeft(manager.fromQuery("value", Long.class));
			return;
		}
		else if (operation.equals("moveRight")) {
			display.moveRight(manager.fromQuery("value", Long.class));
			return;
		}
		else if (operation.equals("showDialog")) {
			display.showDialog();
			return;
		}
		else if (operation.equals("selectCatalogInstant")) {
			display.selectCatalogInstant(manager.fromQuery("value", io.intino.sumus.box.schemas.CatalogInstant.class));
			return;
		}
		super.execute();
	}
}