package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.SumusTimeScatterChartDialog;
import io.intino.konos.alexandria.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.SumusTimeScatterChartDialogNotifier;
import io.intino.konos.alexandria.ui.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.ui.spark.UISparkManager;

public class SumusTimeScatterChartDialogRequester extends AlexandriaDisplayRequester {

	public SumusTimeScatterChartDialogRequester(UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SumusTimeScatterChartDialog display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("query")) {
			display.query(manager.fromQuery("value", io.intino.sumus.box.schemas.ScatterQuery.class));
			return;
		}
		super.execute();
	}
}