package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.SumusTimeChartDesign;
import io.intino.konos.alexandria.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.SumusTimeChartDesignNotifier;
import io.intino.konos.alexandria.ui.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.ui.spark.UISparkManager;

public class SumusTimeChartDesignRequester extends AlexandriaDisplayRequester {

	public SumusTimeChartDesignRequester(UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SumusTimeChartDesign display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("selectTickets")) {
			display.selectTickets(manager.fromQuery("value", String[].class));
			return;
		}
		super.execute();
	}
}