package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.SumusTimeBarChart;
import io.intino.konos.alexandria.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.SumusTimeBarChartNotifier;
import io.intino.konos.alexandria.ui.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.ui.spark.UISparkManager;

public class SumusTimeBarChartRequester extends AlexandriaDisplayRequester {

	public SumusTimeBarChartRequester(UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SumusTimeBarChart display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("showDialog")) {
			display.showDialog();
			return;
		}
		super.execute();
	}
}