package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.SumusOlap;
import io.intino.konos.alexandria.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.SumusOlapNotifier;
import io.intino.konos.alexandria.ui.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.ui.spark.UISparkManager;

public class SumusOlapRequester extends AlexandriaDisplayRequester {

	public SumusOlapRequester(UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SumusOlap display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("addTicket")) {
			display.addTicket(manager.fromQuery("value", String.class));
			return;
		}
		else if (operation.equals("removeTicket")) {
			display.removeTicket(manager.fromQuery("value", String.class));
			return;
		}
		else if (operation.equals("moveTickets")) {
			display.moveTickets(manager.fromQuery("value", String[].class));
			return;
		}
		else if (operation.equals("updateScale")) {
			display.updateScale(manager.fromQuery("value", String.class));
			return;
		}
		else if (operation.equals("updateRange")) {
			display.updateRange(manager.fromQuery("value", io.intino.sumus.box.schemas.RequestRange.class));
			return;
		}
		else if (operation.equals("export")) {
			io.intino.konos.alexandria.ui.spark.UIFile file = display.export(manager.fromQuery("value", io.intino.sumus.box.schemas.RequestRange.class));
			manager.write(file.content(), file.label(), file.embedded());
			return;
		}
		else if (operation.equals("removeDrillTag")) {
			display.removeDrillTag(manager.fromQuery("value", String.class));
			return;
		}
		else if (operation.equals("selectChart")) {
			display.selectChart(manager.fromQuery("value", io.intino.sumus.box.schemas.ChartOption.class));
			return;
		}
		else if (operation.equals("removeFilter")) {
			display.removeFilter(manager.fromQuery("value", String.class));
			return;
		}
		super.execute();
	}
}