package io.intino.sumus.box.displays.builders;

import io.intino.sumus.box.schemas.Categorization;
import io.intino.sumus.box.schemas.Drill;
import io.intino.sumus.box.schemas.Tag;

import java.util.ArrayList;
import java.util.List;

public class DrillBuilder {

    public static Drill build(io.intino.sumus.analytics.viewmodels.Drill drill) {
        if (drill == null) return null;

        return new Drill().categorization(categorization(drill.categorization))
                .tagList(build(drill.tags));
    }

    private static Categorization categorization(io.intino.sumus.graph.Categorization categorization) {
        return new Categorization().name(categorization.name$()).label(categorization.label());
    }

    private static List<Tag> build(List<String> tags) {
        List<Tag> result = new ArrayList<>();
        tags.forEach(tag -> result.add(build(tag)));
        return result;
    }

    private static Tag build(String tag) {
        return new Tag().name(tag).label(tag);
    }
}
