package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.viewmodels.CategorizationViewBuilder;
import io.intino.sumus.analytics.viewmodels.TagView;
import io.intino.sumus.analytics.viewmodels.Drill;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.builders.TagViewBuilder;
import io.intino.sumus.box.displays.notifiers.SumusCategorizationNotifier;
import io.intino.sumus.box.schemas.CategorizationToggleDialog;
import io.intino.sumus.graph.Categorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

import static io.intino.sumus.box.displays.builders.CategorizationViewBuilder.build;
import static java.util.stream.Collectors.toList;

public class SumusCategorization extends SumusDisplay<SumusCategorizationNotifier> {
	private final List<Consumer<List<String>>> selectListeners = new ArrayList<>();
	private final List<String> tags = new ArrayList<>();
	private Categorization categorization;

	public SumusCategorization(SumusBox box) {
		super(box);
	}

	public void categorization(Categorization categorization) {
		this.categorization = categorization;
	}

	public Categorization categorization() {
		return this.categorization;
	}

	public void toggle(CategorizationToggleDialog dialog) {
		this.select(dialog.tags());
	}

	public void onSelect(Consumer<List<String>> consumer) {
		selectListeners.add(consumer);
		children(SumusCategorization.class).forEach(d -> d.onSelect(consumer));
	}

	public Drill asDrill() {
		return (tags.size() > 0) ? new Drill(categorization, tags) : null;
	}

	public boolean hasFilterCondition() {
		return tags.size() > 0;
	}

	public FilterCondition asFilterCondition() {
		return new FilterCondition(categorization, tags);
	}

	public void toggle(String tag) {

		if (tags.contains(tag)) tags.remove(tag);
		else tags.add(tag);

		refreshSelected();
		notifySelection();
	}

	public void select(String[] tags) {
		select(Arrays.asList(tags));
	}

	public void select(List<String> tagList) {
		tags.clear();
		List<String> calculate = categorization.tags(accessList());
		tagList.forEach(key -> {
			List<String> foundTags = calculate.stream().filter(c -> c.equals(key)).collect(toList());
			if (foundTags.size() > 0) tags.add(foundTags.get(0));
		});
		refreshSelected();
		notifySelection();
	}

	public void selectAll() {
		tags.clear();
		tags.addAll(categorization.tags(accessList()));
		refreshSelected();
		notifySelection();
	}

	public void selectNone() {
		tags.clear();
		refreshSelected();
		notifySelection();
	}

	public void maxSelection(int count) {
		notifier.refreshMaxSelection(count);
	}

	@Override
	public void refresh() {
		super.refresh();
		notifier.refreshCategorization(build(CategorizationViewBuilder.build(categorization, accessList())));
	}

	private void notifySelection() {
		selectListeners.forEach(c -> c.accept(tags));
	}

	private void refreshSelected() {
		notifier.refreshSelected(TagViewBuilder.buildList(tags.stream().map(TagView::new).collect(toList())));
	}

//    private List<Tag> filter(Collection<Tag> values) {
//        if (categorization().parent() == null) return new ArrayList<>(values);
//
//        TemporalCategorization temporalParent = (TemporalCategorization)parent;
//        values.stream().filter(v -> {
//            TemporalTag value = (TemporalTag)v;
//            TimeScale scale = temporalParent.range.scale();
//            scale.normalise(value.timeStamp.instant());
//
//            v.
//        })
//    }

}