package io.intino.sumus.box;

import io.intino.konos.alexandria.ui.displays.AlexandriaAbstractCatalog;
import io.intino.konos.alexandria.ui.displays.Soul;
import io.intino.konos.alexandria.ui.model.Catalog;
import io.intino.konos.alexandria.ui.model.Item;
import io.intino.konos.alexandria.ui.model.catalog.arrangement.Grouping;
import io.intino.konos.alexandria.ui.services.AuthService;
import io.intino.konos.alexandria.ui.services.EditorService;
import io.intino.sumus.Settings;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.helpers.TranslatorHelper;
import io.intino.tara.magritte.Graph;

import java.net.URL;
import java.util.Collection;

public class SumusBox extends AbstractBox {
	private SumusGraph sumusGraph;
	private Settings settings;
	private TranslatorHelper translatorHelper;

	public SumusBox(String[] args) {
		super(args);
	}

	public SumusBox(SumusConfiguration configuration) {
		super(configuration);
		this.settings = new Settings(configuration.args());
	}

	@Override
	public io.intino.konos.alexandria.Box put(Object o) {
		if (o instanceof Graph) this.sumusGraph = ((Graph) o).as(SumusGraph.class);
		if (o instanceof TranslatorHelper) this.translatorHelper = (TranslatorHelper) o;
		return this;
	}

	public io.intino.konos.alexandria.Box open() {
		this.translatorHelper = new TranslatorHelper(sumusGraph);
		super.open();
		graph().init();
		return this;
	}

	public SumusGraph graph() {
		return sumusGraph;
	}

	public Settings actionsConfiguration() {
		return settings;
	}

	public void close() {
		super.close();
	}

	@Override
	protected AuthService authService(URL authServiceUrl) {
		return null;
	}

	@Override
	protected EditorService editorService(URL editorServiceUrl) {
		return null;
	}

	public TranslatorHelper translatorHelper() {
		return translatorHelper;
	}

	public void refreshDisplaysOf(Catalog catalog, Grouping grouping) {
		uiSouls.values().stream().map(Soul::getAll).flatMap(Collection::stream)
				.filter(d -> d instanceof AlexandriaAbstractCatalog && ((AlexandriaAbstractCatalog) d)
						.isFor(catalog)).forEach(d -> ((AlexandriaAbstractCatalog) d).refresh(grouping));
	}

	public void refreshDisplaysOf(Catalog catalog, boolean categorizationsHaveChanges, Item... items) {
		uiSouls.values().stream().map(Soul::getAll).flatMap(Collection::stream)
				.filter(d -> d instanceof AlexandriaAbstractCatalog && ((AlexandriaAbstractCatalog) d)
						.isFor(catalog)).forEach(d -> {
			AlexandriaAbstractCatalog display = (AlexandriaAbstractCatalog) d;
			display.dirty(true);
			if (categorizationsHaveChanges || items.length == 0)
				display.refresh();
			else
				display.refresh(items);
		});
	}

}