package io.intino.sumus.box;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import static org.slf4j.Logger.ROOT_LOGGER_NAME;

import io.intino.konos.alexandria.ui.displays.Soul;

public abstract class AbstractBox extends io.intino.konos.alexandria.ui.UIBox {
	private static Logger logger = LoggerFactory.getLogger(ROOT_LOGGER_NAME);
	protected SumusConfiguration configuration;

    protected Map<String, Soul> uiSouls = new java.util.HashMap<>();
    private java.util.List<io.intino.konos.alexandria.ui.UIBox.SoulsClosed> soulsClosedListeners = new java.util.ArrayList<>();
	private io.intino.konos.alexandria.ui.services.AuthService authService;
	private io.intino.konos.alexandria.ui.services.EditorService editorService;

	public AbstractBox(String[] args) {
		this(new SumusConfiguration(args));
	}

	public AbstractBox(SumusConfiguration configuration) {

		this.configuration = configuration;
		initLogger();
		this.authService = null;
		this.editorService = null;
		if(configuration().get("port") != null && !configuration().get("port").isEmpty())io.intino.konos.alexandria.rest.AlexandriaSparkBuilder.setup(Integer.parseInt(configuration().get("port")), "www/");
		io.intino.konos.alexandria.rest.AlexandriaSparkBuilder.setUI(true);
		io.intino.konos.alexandria.rest.AlexandriaSparkBuilder.addParameters(this.authService, this.editorService);
	}

	public SumusConfiguration configuration() {
		return configuration;
	}

	@Override
	public io.intino.konos.alexandria.Box put(Object o) {

		return this;
	}

	public io.intino.konos.alexandria.Box open() {
		if (owner != null) owner.open();
		initLogger();
		initUI();
		initRESTServices();
		initJMXServices();
		initJMSServices();
		initDataLake();
		initTasks();
		initSlackBots();
		return this;
	}

	public void close() {
		if(owner != null) owner.close();
		io.intino.konos.alexandria.rest.AlexandriaSparkBuilder.instance().stop();


	}

	public java.util.List<Soul> souls() {
	return new java.util.ArrayList<>(uiSouls.values());
}

	public java.util.Optional<Soul> soul(String clientId) {
		return java.util.Optional.ofNullable(uiSouls.get(clientId));
	}

	public void registerSoul(String clientId, Soul soul) {

		uiSouls.put(clientId, soul);
	}

	public void unRegisterSoul(String clientId) {

		uiSouls.remove(clientId);
		if (uiSouls.size() <= 0) notifySoulsClosed();
	}

	public void onSoulsClosed(io.intino.konos.alexandria.ui.UIBox.SoulsClosed listener) {

		this.soulsClosedListeners.add(listener);
	}

	private void notifySoulsClosed() {
		soulsClosedListeners.forEach(l -> l.accept());
	}

	protected abstract io.intino.konos.alexandria.ui.services.AuthService authService(java.net.URL authServiceUrl);
	protected abstract io.intino.konos.alexandria.ui.services.EditorService editorService(java.net.URL editorServiceUrl);

public io.intino.konos.alexandria.ui.services.EditorService editorService() {
	return this.editorService;
}



	private void initRESTServices() {

	}

	private void initJMSServices() {


	}

	private void initJMXServices() {

	}

	private void initSlackBots() {

	}

	private void initUI() {
		if (configuration().get("port") == null || !io.intino.konos.alexandria.rest.AlexandriaSparkBuilder.isUI()) return;
		io.intino.konos.alexandria.ui.UIAlexandriaSpark sparkInstance = (io.intino.konos.alexandria.ui.UIAlexandriaSpark) io.intino.konos.alexandria.rest.AlexandriaSparkBuilder.instance();
		PlatformUi.init(sparkInstance, (SumusBox) this);
		io.intino.konos.alexandria.ui.UiElements.initDisplays(sparkInstance);

		sparkInstance.start();
		logger.info("UI PlatformUi: started!");
	}

	private void initDataLake() {

	}

	private void initTasks() {

	}

	private void initLogger() {
		final java.util.logging.Logger logger = java.util.logging.Logger.getGlobal();
		final ConsoleHandler handler = new ConsoleHandler();
		handler.setLevel(Level.INFO);
		handler.setFormatter(new io.intino.konos.alexandria.LogFormatter("log"));
		logger.setUseParentHandlers(false);
		logger.addHandler(handler);
	}

	private static java.net.URL url(String url) {
		try {
		return new java.net.URL(url);
		} catch (java.net.MalformedURLException e) {
			return null;
		}
	}
}