package io.intino.sumus.analytics.viewmodels;

import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.analytics.Scaler;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CrossTable {
	private final AbstractMetric.Unit unit;
	private Double maxValue = null;
	private Map<String, Double> values = new HashMap<>();

	public CrossTable(AbstractMetric.Unit unit) {
		this.unit = unit;
	}

	public void register(List<String> tags, double value) {
		String key = tagsKey(tags);
		if (!values.containsKey(key)) values.put(key, 0D);
		value += values.get(key);
		values.put(key, value);
		updateBounds(value);
	}

	public Double value(List<String> tags) {
		String key = tagsKeyFromIds(tags);
		return values.containsKey(key) ? values.get(key) : 0D;
	}

	public Scaler scaler() {
		AbstractMetric metric = unit.core$().ownerAs(AbstractMetric.class);
		Double maxValue = this.maxValue != null ? this.maxValue : -1D;
		return metric.scaler().scaler(maxValue, unit);
	}

	private String tagsKeyFromIds(List<String> tags) {
		tags.sort(Comparator.naturalOrder());
		return tags.stream().collect(Collectors.joining());
	}

	private String tagsKey(List<String> tags) {
		tags.sort(String::compareTo);
		return tags.stream().collect(Collectors.joining());
	}

	private void updateBounds(double value) {
		if (maxValue == null || maxValue < value)
			maxValue = value;
	}

}
