package io.intino.sumus.analytics.viewmodels;

import io.intino.sumus.graph.AbstractAccess;
import io.intino.sumus.graph.Categorization;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;
import static java.util.stream.Collectors.toList;

public class CategorizationViewBuilder {

	public static CategorizationView build(Categorization categorization, List<AbstractAccess> accessList) {
		return createCategorizationView(categorization, emptyList(), accessList);
	}

	public static List<CategorizationView> build(List<? extends Categorization> categorizations, Map<Categorization, List<String>> disallowed, List<AbstractAccess> accessList) {
		return categorizations.stream()
				.map(categorization -> buildView(categorization, disallowed, accessList))
				.flatMap(Collection::stream)
				.collect(toList());
	}

	private static List<CategorizationView> buildView(Categorization categorization, Map<Categorization, List<String>> disallowed, List<AbstractAccess> accessList) {
		return singletonList(createCategorizationView(categorization, disallowedTags(disallowed.values()), accessList));
	}

	private static CategorizationView createCategorizationView(Categorization categorization, List<String> disallowedTags, List<AbstractAccess> accessList) {
		if (disallowedTags.isEmpty()) {
			return new CategorizationView(categorization, categorization.tags(accessList));
		}
		List<String> tags = categorization.tags(accessList).stream().filter(disallowedTags::contains).collect(toList());
		return new CategorizationView(categorization, tags.isEmpty() ? categorization.tags(accessList) : tags);
	}

	private static List<String> disallowedTags(Collection<List<String>> disallowed) {
		return disallowed.stream().flatMap(Collection::stream).collect(toList());
	}
}
