package io.intino.sumus.analytics.viewmodels;

import io.intino.sumus.graph.Categorization;

import java.util.List;

import static java.util.stream.Collectors.toList;

public class CategorizationView {

	private final String name;
	private final String label;
	private final List<TagView> tags;

	public CategorizationView(Categorization categorization, List<String> tags) {
		this.name = categorization.name$();
		this.label = categorization.label();
		this.tags = tags.stream()
				.sorted(String::compareTo)
				.map(TagView::new)
				.collect(toList());
	}

	public String name() {
		return name;
	}

	public String label() {
		return label;
	}

	public List<TagView> tags() {
		return tags;
	}

}
