/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries.tdigest;

import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.TDigest;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.datawarehouse.store.Bucket;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.Distribution;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.queries.Drill;
import io.intino.sumus.queries.tdigest.Query;
import io.intino.sumus.queries.tdigest.QueryResult;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryExecutor {
    private final Query query;
    private final QueryResult result;
    private final Map<String, List<Drill>> drillMap = new HashMap<String, List<Drill>>();

    private QueryExecutor(Query query) {
        this.query = query;
        this.result = new QueryResult(query);
    }

    public static QueryResult execute(Query query) {
        QueryExecutor executor = new QueryExecutor(query);
        executor.execute();
        return executor.result;
    }

    private void execute() {
        this.prepareDrills();
        this.processNamespace(this.query.nameSpace());
    }

    private void prepareDrills() {
        for (String id : this.allIds()) {
            for (Drill drill : this.query.drills()) {
                if (!drill.contains(Collections.singletonList(id))) continue;
                if (!this.drillMap.containsKey(id)) {
                    this.drillMap.put(id, new ArrayList());
                }
                this.drillMap.get(id).add(drill);
            }
        }
    }

    private List<String> allIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (Drill drill : this.query.drills()) {
            ids.addAll(drill.tags());
        }
        return ids;
    }

    private void processNamespace(NameSpace nameSpace) {
        Map<Cube, Bucket> buckets = this.bucketByCubeType(this.query.instant(), nameSpace);
        for (Distribution.Source source : this.query.sources()) {
            Bucket bucket = buckets.get((Object)this.cubeOf(source));
            if (bucket == null) continue;
            this.registerDistribution(source, bucket);
        }
    }

    private void registerDistribution(Distribution.Source source, Bucket bucket) {
        List<io.intino.sumus.datawarehouse.store.TDigest> tDigests = this.filter(bucket.tDigests(source.property().label()));
        if (this.query.drills().isEmpty()) {
            this.result.register(source, this.percentilesOf(tDigests));
        }
        this.drillMap(tDigests).forEach((key, value) -> this.result.register(source, (Drill)key, this.percentilesOf((List<io.intino.sumus.datawarehouse.store.TDigest>)value)));
    }

    private List<Double> percentilesOf(List<io.intino.sumus.datawarehouse.store.TDigest> tDigests) {
        AVLTreeDigest avlDigest = (AVLTreeDigest)AVLTreeDigest.createDigest((double)100.0);
        for (io.intino.sumus.datawarehouse.store.TDigest tDigest : tDigests) {
            avlDigest.add((TDigest)tDigest.avlTreeDigest());
        }
        return this.percentilesOf(avlDigest);
    }

    private List<Double> percentilesOf(AVLTreeDigest avlDigest) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (double i = 0.0; i <= 1.0; i += 0.01) {
            result.add(avlDigest.quantile(i));
        }
        result.add(avlDigest.quantile(1.0));
        return result;
    }

    private List<io.intino.sumus.datawarehouse.store.TDigest> filter(List<io.intino.sumus.datawarehouse.store.TDigest> tDigests) {
        if (this.query.filter() == null) {
            return tDigests;
        }
        ArrayList<io.intino.sumus.datawarehouse.store.TDigest> result = new ArrayList<io.intino.sumus.datawarehouse.store.TDigest>();
        for (io.intino.sumus.datawarehouse.store.TDigest tDigest : tDigests) {
            if (!this.query.filter().contains(tDigest.entityIds())) continue;
            result.add(tDigest);
        }
        return result;
    }

    private Map<Drill, List<io.intino.sumus.datawarehouse.store.TDigest>> drillMap(List<io.intino.sumus.datawarehouse.store.TDigest> digests) {
        Map<Drill, List<io.intino.sumus.datawarehouse.store.TDigest>> digestMap = this.digestMap();
        for (io.intino.sumus.datawarehouse.store.TDigest digest : digests) {
            for (String id : digest.entityIds()) {
                for (Drill drill : (List)this.drillMap.getOrDefault(id, new ArrayList())) {
                    digestMap.get(drill).add(digest);
                }
            }
        }
        return digestMap;
    }

    private Map<Drill, List<io.intino.sumus.datawarehouse.store.TDigest>> digestMap() {
        HashMap<Drill, List<io.intino.sumus.datawarehouse.store.TDigest>> digestMap = new HashMap<Drill, List<io.intino.sumus.datawarehouse.store.TDigest>>();
        for (Drill drill : this.query.drills()) {
            digestMap.put(drill, new ArrayList());
        }
        return digestMap;
    }

    private Map<Cube, Bucket> bucketByCubeType(Instant instant, NameSpace nameSpace) {
        HashMap<Cube, Bucket> cubes = new HashMap<Cube, Bucket>();
        for (Cube cube : this.cubes()) {
            Bucket bucket = new Bucket(cube, nameSpace, new TimeStamp(instant, this.query.scale()));
            if (!bucket.exists()) continue;
            cubes.put(cube, bucket);
        }
        return cubes;
    }

    private Set<Cube> cubes() {
        HashSet<Cube> concepts = new HashSet<Cube>();
        for (Distribution.Source source : this.query.sources()) {
            concepts.add(this.cubeOf(source));
        }
        return concepts;
    }

    private Cube cubeOf(Distribution.Source source) {
        return (Cube)source.property().core$().ownerAs(Cube.class);
    }
}

