/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries.digest;

import io.intino.sumus.TimeStamp;
import io.intino.sumus.datawarehouse.store.Bucket;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.graph.AbstractCategorization;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.queries.Drill;
import io.intino.sumus.queries.digest.Query;
import io.intino.sumus.queries.digest.QueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class QueryExecutor {
    private final Query query;
    private final QueryResult result;
    private final Map<Cube, List<AbstractCategorization.DigestTagger>> taggers = new ConcurrentHashMap<Cube, List<AbstractCategorization.DigestTagger>>();

    private QueryExecutor(Query query) {
        this.query = query.commit();
        this.result = new QueryResult(query);
    }

    public static QueryResult execute(Query query) {
        QueryExecutor executor = new QueryExecutor(query);
        executor.execute();
        return executor.result;
    }

    private void execute() {
        for (NameSpace nameSpace : this.query.nameSpaces()) {
            this.processNamespaces(nameSpace);
        }
    }

    private void processNamespaces(NameSpace nameSpace) {
        List<Query.SubQuery> queries = this.query.subQueries().stream().filter((? super T s) -> ((Object)((Object)s.nameSpace)).equals((Object)nameSpace)).collect(Collectors.toList());
        this.queryTimeStamps(queries).parallelStream().forEach(i -> this.processNamespace((TimeStamp)i, (Collection<Query.SubQuery>)queries));
    }

    private void processNamespace(TimeStamp stamp, Collection<Query.SubQuery> queries) {
        Collection<Query.SubQuery> availableQueries = this.availableQueries(stamp, queries);
        Map<Cube, BucketWithDrills> bucketMap = this.bucketByCubeType(stamp, availableQueries);
        for (Query.SubQuery query : availableQueries) {
            BucketWithDrills bucket = bucketMap.get((Object)query.cube());
            if (bucket == null) continue;
            if (bucket.drilledDigests.isEmpty()) {
                this.result.register(query, stamp, query.formula.calculate(bucket.filteredDigests));
                continue;
            }
            bucket.drilledDigests.forEach((drill, value) -> this.result.register(query, (Drill)drill, stamp, query.formula.calculate((List<Digest>)value)));
        }
    }

    private Collection<Query.SubQuery> availableQueries(TimeStamp stamp, Collection<Query.SubQuery> queries) {
        if (this.query.timeStamps().contains(stamp)) {
            return queries;
        }
        ArrayList<Query.SubQuery> subQueries = new ArrayList<Query.SubQuery>();
        for (Query.SubQuery subQuery : queries) {
            if (!subQuery.ts.contains(stamp)) continue;
            subQueries.add(subQuery);
        }
        return subQueries;
    }

    private Map<Drill, List<Digest>> groupDigestsByDrill(List<DigestWithTags> digests, List<Drill> temporalDrills) {
        HashMap<Drill, List<Digest>> digestsByDrill = new HashMap<Drill, List<Digest>>();
        if (!this.query.drills().isEmpty()) {
            this.groupDigestsByDrill(digests, digestsByDrill);
        }
        if (temporalDrills != null) {
            this.groupDigestsByDrill(digests, digestsByDrill, temporalDrills);
        }
        return digestsByDrill;
    }

    private synchronized void groupDigestsByDrill(List<DigestWithTags> digests, Map<Drill, List<Digest>> digestsByDrill) {
        this.query.drills().forEach(d -> {
            List cfr_ignored_0 = digestsByDrill.put((Drill)d, new ArrayList());
        });
        for (DigestWithTags d2 : digests) {
            this.query.drills().stream().filter((? super T drill) -> drill.contains(d.tags)).forEach(drill -> ((List)digestsByDrill.get(drill)).add(d.digest));
        }
    }

    private void groupDigestsByDrill(List<DigestWithTags> digests, Map<Drill, List<Digest>> digestsByDrill, List<Drill> temporalDrills) {
        temporalDrills.forEach(d -> {
            List cfr_ignored_0 = digestsByDrill.put((Drill)d, new ArrayList());
        });
        for (DigestWithTags d2 : digests) {
            temporalDrills.stream().filter((? super T t) -> t.contains(d.digest.ts())).forEach(t -> ((List)digestsByDrill.get(t)).add(d.digest));
        }
    }

    private Collection<TimeStamp> queryTimeStamps(List<Query.SubQuery> queries) {
        LinkedHashSet<TimeStamp> stamps = new LinkedHashSet<TimeStamp>();
        queries.forEach(q -> stamps.addAll(q.ts));
        return stamps;
    }

    private List<DigestWithTags> filter(List<DigestWithTags> digests) {
        if (this.query.filter() == null) {
            return digests;
        }
        ArrayList<DigestWithTags> result = new ArrayList<DigestWithTags>();
        for (DigestWithTags digest : digests) {
            if (!this.query.filter().contains(digest.tags)) continue;
            result.add(digest);
        }
        return result;
    }

    private Map<Cube, BucketWithDrills> bucketByCubeType(TimeStamp stamp, Collection<Query.SubQuery> queries) {
        HashMap<Cube, BucketWithDrills> cubes = new HashMap<Cube, BucketWithDrills>();
        for (Cube cube : this.cubes(queries)) {
            Bucket bucket = new Bucket(cube, queries.iterator().next().nameSpace, stamp);
            if (!bucket.exists()) continue;
            cubes.put(cube, new BucketWithDrills(bucket));
        }
        return cubes;
    }

    private Set<Cube> cubes(Collection<Query.SubQuery> queries) {
        HashSet<Cube> concepts = new HashSet<Cube>();
        for (Query.SubQuery query : queries) {
            concepts.add(query.cube());
        }
        return concepts;
    }

    private List<DigestWithTags> withTags(Cube cube, List<Digest> digests) {
        List<DigestWithTags> result = digests.stream().map(x$0 -> new DigestWithTags((Digest)x$0)).collect(Collectors.toList());
        if (this.query.filter() == null && this.query.drills().isEmpty()) {
            return result;
        }
        List<AbstractCategorization.DigestTagger> taggers = this.taggersOf(cube);
        result.forEach(d -> taggers.forEach(t -> d.addTags(t.tag(d.digest))));
        return result;
    }

    private List<AbstractCategorization.DigestTagger> taggersOf(Cube cube) {
        return cube.graph().categorizationList().stream().map(c -> c.digestTagger(cube)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    class DigestWithTags {
        Digest digest;
        Set<String> tags = new HashSet<String>();

        DigestWithTags(Digest digest) {
            this.digest = digest;
        }

        void addTags(List<String> tags) {
            this.tags.addAll(tags);
        }
    }

    class BucketWithDrills {
        List<Digest> filteredDigests;
        Map<Drill, List<Digest>> drilledDigests;

        BucketWithDrills(Bucket bucket) {
            List digestsWithTags = QueryExecutor.this.filter(QueryExecutor.this.withTags(bucket.cube(), bucket.digests()));
            this.filteredDigests = digestsWithTags.stream().map(d -> d.digest).collect(Collectors.toList());
            QueryExecutor.this.result.register(this.filteredDigests);
            this.drilledDigests = QueryExecutor.this.groupDigestsByDrill((List<DigestWithTags>)digestsWithTags, QueryExecutor.this.query.drills(bucket.timeStamp()));
        }
    }
}

