/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.sumus.TimeStamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Filter {
    private final List<Set<String>> tags = new ArrayList<Set<String>>();
    private final Set<TimeStamp> timeStamps = new HashSet<TimeStamp>();

    public void addTags(List<String> tags) {
        this.tags.add(new HashSet<String>(tags));
    }

    public void addTimeStamp(TimeStamp timeStamps) {
        this.timeStamps.add(timeStamps);
    }

    public boolean contains(Collection<String> tags) {
        for (Set<String> items : this.tags) {
            if (this.containsAnyOf(tags, items)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String id) {
        return this.contains(Collections.singletonList(id));
    }

    private boolean containsAnyOf(Collection<String> tags, Set<String> items) {
        for (String tag : tags) {
            if (!items.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean isTemporal() {
        return !this.timeStamps.isEmpty();
    }

    public boolean contains(TimeStamp timeStamp) {
        return this.timeStamps.contains(timeStamp);
    }
}

