/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.konos.alexandria.ui.model.TimeRange;
import io.intino.sumus.analytics.FormulaLoader;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.helpers.MathHelper;
import io.intino.sumus.queries.AbstractQuery;
import io.intino.sumus.queries.digest.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CrossTableQuery
extends AbstractQuery {
    private final Map<Categorization, List<String>> columns = new HashMap<Categorization, List<String>>();
    private final Map<Categorization, List<String>> rows = new HashMap<Categorization, List<String>>();
    private final Map<Categorization, List<String>> filters = new HashMap<Categorization, List<String>>();
    private Ticket ticket = null;
    private NameSpace nameSpace;
    private TimeRange timeRange;

    private CrossTableQuery() {
    }

    public Ticket ticket() {
        return this.ticket;
    }

    public Map<Categorization, List<String>> columns() {
        return this.columns;
    }

    public Map<Categorization, List<String>> rows() {
        return this.rows;
    }

    public Map<Categorization, List<String>> filters() {
        return this.filters;
    }

    public NameSpace nameSpace() {
        return this.nameSpace;
    }

    public TimeRange timeRange() {
        return this.timeRange;
    }

    public Query toRawQuery(FormulaLoader loader) {
        Query result = new Query();
        this.addScope(result);
        loader.formulas(Collections.singletonList(this.ticket)).forEach(formula -> result.add(this.nameSpace, (MeasureIndicator.Formula)((Object)formula)));
        result.add(this.timeRange);
        this.filters.values().forEach(result::filter);
        Set<Set<String>> cartesianColumns = this.cartesianProduct(new ArrayList<List<String>>(this.columns.values()));
        Set<Set<String>> cartesianRows = this.cartesianProduct(new ArrayList<List<String>>(this.rows.values()));
        cartesianColumns.forEach(cartesianColumn -> cartesianRows.forEach(cartesianRow -> {
            List<String> tags = this.mergeSets((Set<String>)cartesianColumn, (Set<String>)cartesianRow);
            result.drill(tags);
        }));
        return result;
    }

    private Set<Set<String>> cartesianProduct(final List<List<String>> values) {
        Set[] set = new Set[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            set[i] = new LinkedHashSet(values.get(i));
        }
        if (set.length == 1) {
            return new LinkedHashSet<Set<String>>(){
                {
                    ((List)values.get(0)).forEach(value -> this.add(new LinkedHashSet<String>(){
                        {
                            this.add(value);
                        }
                    }));
                }
            };
        }
        return MathHelper.cartesianProduct(set);
    }

    private List<String> mergeSets(Set<String> column, Set<String> row) {
        ArrayList<String> tags = new ArrayList<String>(column);
        tags.addAll(row);
        return tags;
    }

    public static class Builder
    extends AbstractQuery.Builder<CrossTableQuery> {
        public Builder() {
            super(new CrossTableQuery());
        }

        public CrossTableQuery build(NameSpace nameSpace, Ticket ticket, TimeRange timeRange) {
            this.nameSpace(nameSpace);
            this.ticket(ticket);
            this.timeRange(timeRange);
            return (CrossTableQuery)this.query;
        }

        private Builder ticket(Ticket ticket) {
            ((CrossTableQuery)this.query).ticket = ticket;
            return this;
        }

        private Builder nameSpace(NameSpace nameSpace) {
            ((CrossTableQuery)this.query).nameSpace = nameSpace;
            return this;
        }

        private Builder timeRange(TimeRange timeRange) {
            ((CrossTableQuery)this.query).timeRange = timeRange;
            return this;
        }

        public Builder addColumn(Categorization categorization, List<String> tags) {
            ((CrossTableQuery)this.query).columns.put(categorization, tags);
            return this;
        }

        public Builder addRow(Categorization categorization, List<String> tags) {
            ((CrossTableQuery)this.query).rows.put(categorization, tags);
            return this;
        }

        public Builder filter(List<FilterCondition> filterConditions) {
            filterConditions.forEach(filter -> ((CrossTableQuery)this.query).filters.put(filter.categorization, filter.tags));
            return this;
        }
    }
}

