/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.queries.Scope;
import io.intino.sumus.queries.digest.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AbstractQuery {
    protected Scope scope = null;

    public Optional<Scope> scope() {
        return Optional.ofNullable(this.scope);
    }

    protected Map<Categorization, List<String>> toMap(List<FilterCondition> filters) {
        HashMap<Categorization, List<String>> result = new HashMap<Categorization, List<String>>();
        filters.forEach(fc -> {
            Categorization categorization = fc.categorization;
            List<String> tags = fc.tags;
            if (!result.containsKey((Object)categorization)) {
                result.put(categorization, new ArrayList());
            }
            List categorizationTags = (List)result.get((Object)categorization);
            categorizationTags.removeAll(tags);
            categorizationTags.addAll(tags);
        });
        return result;
    }

    protected void addScope(Query query) {
        if (this.scope == null) {
            return;
        }
        this.scope.tags().forEach(query::filter);
    }

    protected void addScope(io.intino.sumus.queries.temporalrecord.Query query) {
        if (this.scope == null) {
            return;
        }
        this.scope.tags().forEach(query::filter);
    }

    public static class Builder<Q extends AbstractQuery> {
        protected final Q query;

        public Builder(Q query) {
            this.query = query;
        }

        public <B extends Builder> B scope(Scope scope) {
            ((AbstractQuery)this.query).scope = scope;
            return (B)this;
        }
    }
}

