/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.konos.alexandria.ui.model.Catalog;
import io.intino.sumus.CatalogList;
import io.intino.sumus.graph.AbstractAccess;
import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.graph.Access;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Checker;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.Episode;
import io.intino.sumus.graph.Event;
import io.intino.sumus.graph.Filter;
import io.intino.sumus.graph.GlobalAccess;
import io.intino.sumus.graph.Metric;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.OnClickInstant;
import io.intino.sumus.graph.Palette;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.Report;
import io.intino.sumus.graph.TemporalMetric;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.graph.aspect.AspectEntity;
import io.intino.sumus.graph.dynamic.DynamicEntity;
import io.intino.sumus.graph.functions.NameSpacesLoader;
import io.intino.sumus.graph.geolocated.GeolocatedEntity;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.GraphWrapper;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.utils.I18n;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private List<Record> recordList;
    private List<TemporalRecord> temporalRecordList;
    private List<Entity> entityList;
    private List<Event> eventList;
    private List<Episode> episodeList;
    private List<Report> reportList;
    private List<Cube> cubeList;
    private List<Checker> checkerList;
    private List<GeolocatedEntity> geolocatedEntityList;
    private List<DynamicEntity> dynamicEntityList;
    private List<AspectEntity> aspectEntityList;
    private List<Element> elementList;
    private List<Cluster> clusterList;
    private List<AbstractAccess> abstractAccessList;
    private List<Access> accessList;
    private List<GlobalAccess> globalAccessList;
    private List<Categorization> categorizationList;
    private List<AbstractMetric> abstractMetricList;
    private List<Metric> metricList;
    private List<TemporalMetric> temporalMetricList;
    private List<NameSpace> nameSpaceList;
    private List<Ticket> ticketList;
    private List<Olap> olapList;
    private List<Filter> filterList;
    private List<OnClickInstant> onClickInstantList;
    private Palette palette;

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Sumus");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("Sumus");
        this.recordList = new ArrayList<Record>(wrapper.recordList);
        this.temporalRecordList = new ArrayList<TemporalRecord>(wrapper.temporalRecordList);
        this.entityList = new ArrayList<Entity>(wrapper.entityList);
        this.eventList = new ArrayList<Event>(wrapper.eventList);
        this.episodeList = new ArrayList<Episode>(wrapper.episodeList);
        this.reportList = new ArrayList<Report>(wrapper.reportList);
        this.cubeList = new ArrayList<Cube>(wrapper.cubeList);
        this.checkerList = new ArrayList<Checker>(wrapper.checkerList);
        this.geolocatedEntityList = new ArrayList<GeolocatedEntity>(wrapper.geolocatedEntityList);
        this.dynamicEntityList = new ArrayList<DynamicEntity>(wrapper.dynamicEntityList);
        this.aspectEntityList = new ArrayList<AspectEntity>(wrapper.aspectEntityList);
        this.elementList = new ArrayList<Element>(wrapper.elementList);
        this.clusterList = new ArrayList<Cluster>(wrapper.clusterList);
        this.abstractAccessList = new ArrayList<AbstractAccess>(wrapper.abstractAccessList);
        this.accessList = new ArrayList<Access>(wrapper.accessList);
        this.globalAccessList = new ArrayList<GlobalAccess>(wrapper.globalAccessList);
        this.categorizationList = new ArrayList<Categorization>(wrapper.categorizationList);
        this.abstractMetricList = new ArrayList<AbstractMetric>(wrapper.abstractMetricList);
        this.metricList = new ArrayList<Metric>(wrapper.metricList);
        this.temporalMetricList = new ArrayList<TemporalMetric>(wrapper.temporalMetricList);
        this.nameSpaceList = new ArrayList<NameSpace>(wrapper.nameSpaceList);
        this.ticketList = new ArrayList<Ticket>(wrapper.ticketList);
        this.olapList = new ArrayList<Olap>(wrapper.olapList);
        this.filterList = new ArrayList<Filter>(wrapper.filterList);
        this.onClickInstantList = new ArrayList<OnClickInstant>(wrapper.onClickInstantList);
        this.palette = wrapper.palette;
    }

    public void update() {
        this.recordList = this.graph.rootList(Record.class);
        this.temporalRecordList = this.graph.rootList(TemporalRecord.class);
        this.entityList = this.graph.rootList(Entity.class);
        this.eventList = this.graph.rootList(Event.class);
        this.episodeList = this.graph.rootList(Episode.class);
        this.reportList = this.graph.rootList(Report.class);
        this.cubeList = this.graph.rootList(Cube.class);
        this.checkerList = this.graph.rootList(Checker.class);
        this.geolocatedEntityList = this.graph.rootList(GeolocatedEntity.class);
        this.dynamicEntityList = this.graph.rootList(DynamicEntity.class);
        this.aspectEntityList = this.graph.rootList(AspectEntity.class);
        this.elementList = this.graph.rootList(Element.class);
        this.clusterList = this.graph.rootList(Cluster.class);
        this.abstractAccessList = this.graph.rootList(AbstractAccess.class);
        this.accessList = this.graph.rootList(Access.class);
        this.globalAccessList = this.graph.rootList(GlobalAccess.class);
        this.categorizationList = this.graph.rootList(Categorization.class);
        this.abstractMetricList = this.graph.rootList(AbstractMetric.class);
        this.metricList = this.graph.rootList(Metric.class);
        this.temporalMetricList = this.graph.rootList(TemporalMetric.class);
        this.nameSpaceList = this.graph.rootList(NameSpace.class);
        this.ticketList = this.graph.rootList(Ticket.class);
        this.olapList = this.graph.rootList(Olap.class);
        this.filterList = this.graph.rootList(Filter.class);
        this.onClickInstantList = this.graph.rootList(OnClickInstant.class);
        this.palette = this.graph.rootList(Palette.class).stream().findFirst().orElse(null);
    }

    protected void addNode$(Node node) {
        if (node.is("Record")) {
            this.recordList.add((Record)node.as(Record.class));
        }
        if (node.is("TemporalRecord")) {
            this.temporalRecordList.add((TemporalRecord)node.as(TemporalRecord.class));
        }
        if (node.is("Entity")) {
            this.entityList.add((Entity)node.as(Entity.class));
        }
        if (node.is("Event")) {
            this.eventList.add((Event)node.as(Event.class));
        }
        if (node.is("Episode")) {
            this.episodeList.add((Episode)node.as(Episode.class));
        }
        if (node.is("Report")) {
            this.reportList.add((Report)node.as(Report.class));
        }
        if (node.is("Cube")) {
            this.cubeList.add((Cube)node.as(Cube.class));
        }
        if (node.is("Checker")) {
            this.checkerList.add((Checker)node.as(Checker.class));
        }
        if (node.is("Geolocated#Entity")) {
            this.geolocatedEntityList.add((GeolocatedEntity)node.as(GeolocatedEntity.class));
        }
        if (node.is("Dynamic#Entity")) {
            this.dynamicEntityList.add((DynamicEntity)node.as(DynamicEntity.class));
        }
        if (node.is("Aspect#Entity")) {
            this.aspectEntityList.add((AspectEntity)node.as(AspectEntity.class));
        }
        if (node.is("Element")) {
            this.elementList.add((Element)node.as(Element.class));
        }
        if (node.is("Cluster")) {
            this.clusterList.add((Cluster)node.as(Cluster.class));
        }
        if (node.is("AbstractAccess")) {
            this.abstractAccessList.add((AbstractAccess)node.as(AbstractAccess.class));
        }
        if (node.is("Access")) {
            this.accessList.add((Access)node.as(Access.class));
        }
        if (node.is("GlobalAccess")) {
            this.globalAccessList.add((GlobalAccess)node.as(GlobalAccess.class));
        }
        if (node.is("Categorization")) {
            this.categorizationList.add((Categorization)node.as(Categorization.class));
        }
        if (node.is("AbstractMetric")) {
            this.abstractMetricList.add((AbstractMetric)node.as(AbstractMetric.class));
        }
        if (node.is("Metric")) {
            this.metricList.add((Metric)node.as(Metric.class));
        }
        if (node.is("TemporalMetric")) {
            this.temporalMetricList.add((TemporalMetric)node.as(TemporalMetric.class));
        }
        if (node.is("NameSpace")) {
            this.nameSpaceList.add((NameSpace)node.as(NameSpace.class));
        }
        if (node.is("Ticket")) {
            this.ticketList.add((Ticket)node.as(Ticket.class));
        }
        if (node.is("Olap")) {
            this.olapList.add((Olap)node.as(Olap.class));
        }
        if (node.is("Filter")) {
            this.filterList.add((Filter)node.as(Filter.class));
        }
        if (node.is("OnClickInstant")) {
            this.onClickInstantList.add((OnClickInstant)node.as(OnClickInstant.class));
        }
        if (node.is("Palette")) {
            this.palette = (Palette)node.as(Palette.class);
        }
    }

    protected void removeNode$(Node node) {
        if (node.is("Record")) {
            this.recordList.remove(node.as(Record.class));
        }
        if (node.is("TemporalRecord")) {
            this.temporalRecordList.remove(node.as(TemporalRecord.class));
        }
        if (node.is("Entity")) {
            this.entityList.remove(node.as(Entity.class));
        }
        if (node.is("Event")) {
            this.eventList.remove(node.as(Event.class));
        }
        if (node.is("Episode")) {
            this.episodeList.remove(node.as(Episode.class));
        }
        if (node.is("Report")) {
            this.reportList.remove(node.as(Report.class));
        }
        if (node.is("Cube")) {
            this.cubeList.remove(node.as(Cube.class));
        }
        if (node.is("Checker")) {
            this.checkerList.remove(node.as(Checker.class));
        }
        if (node.is("Geolocated#Entity")) {
            this.geolocatedEntityList.remove(node.as(GeolocatedEntity.class));
        }
        if (node.is("Dynamic#Entity")) {
            this.dynamicEntityList.remove(node.as(DynamicEntity.class));
        }
        if (node.is("Aspect#Entity")) {
            this.aspectEntityList.remove(node.as(AspectEntity.class));
        }
        if (node.is("Element")) {
            this.elementList.remove(node.as(Element.class));
        }
        if (node.is("Cluster")) {
            this.clusterList.remove(node.as(Cluster.class));
        }
        if (node.is("AbstractAccess")) {
            this.abstractAccessList.remove(node.as(AbstractAccess.class));
        }
        if (node.is("Access")) {
            this.accessList.remove(node.as(Access.class));
        }
        if (node.is("GlobalAccess")) {
            this.globalAccessList.remove(node.as(GlobalAccess.class));
        }
        if (node.is("Categorization")) {
            this.categorizationList.remove(node.as(Categorization.class));
        }
        if (node.is("AbstractMetric")) {
            this.abstractMetricList.remove(node.as(AbstractMetric.class));
        }
        if (node.is("Metric")) {
            this.metricList.remove(node.as(Metric.class));
        }
        if (node.is("TemporalMetric")) {
            this.temporalMetricList.remove(node.as(TemporalMetric.class));
        }
        if (node.is("NameSpace")) {
            this.nameSpaceList.remove(node.as(NameSpace.class));
        }
        if (node.is("Ticket")) {
            this.ticketList.remove(node.as(Ticket.class));
        }
        if (node.is("Olap")) {
            this.olapList.remove(node.as(Olap.class));
        }
        if (node.is("Filter")) {
            this.filterList.remove(node.as(Filter.class));
        }
        if (node.is("OnClickInstant")) {
            this.onClickInstantList.remove(node.as(OnClickInstant.class));
        }
        if (node.is("Palette")) {
            this.palette = null;
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public List<Record> recordList() {
        return this.recordList;
    }

    public List<TemporalRecord> temporalRecordList() {
        return this.temporalRecordList;
    }

    public List<Entity> entityList() {
        return this.entityList;
    }

    public List<Event> eventList() {
        return this.eventList;
    }

    public List<Episode> episodeList() {
        return this.episodeList;
    }

    public List<Report> reportList() {
        return this.reportList;
    }

    public List<Cube> cubeList() {
        return this.cubeList;
    }

    public List<Checker> checkerList() {
        return this.checkerList;
    }

    public List<GeolocatedEntity> geolocatedEntityList() {
        return this.geolocatedEntityList;
    }

    public List<DynamicEntity> dynamicEntityList() {
        return this.dynamicEntityList;
    }

    public List<AspectEntity> aspectEntityList() {
        return this.aspectEntityList;
    }

    public List<Element> elementList() {
        return this.elementList;
    }

    public List<Cluster> clusterList() {
        return this.clusterList;
    }

    public List<AbstractAccess> abstractAccessList() {
        return this.abstractAccessList;
    }

    public List<Access> accessList() {
        return this.accessList;
    }

    public List<GlobalAccess> globalAccessList() {
        return this.globalAccessList;
    }

    public List<Categorization> categorizationList() {
        return this.categorizationList;
    }

    public List<AbstractMetric> abstractMetricList() {
        return this.abstractMetricList;
    }

    public List<Metric> metricList() {
        return this.metricList;
    }

    public List<TemporalMetric> temporalMetricList() {
        return this.temporalMetricList;
    }

    public List<NameSpace> nameSpaceList() {
        return this.nameSpaceList;
    }

    public List<Ticket> ticketList() {
        return this.ticketList;
    }

    public List<Olap> olapList() {
        return this.olapList;
    }

    public List<Filter> filterList() {
        return this.filterList;
    }

    public List<OnClickInstant> onClickInstantList() {
        return this.onClickInstantList;
    }

    public Palette palette() {
        return this.palette;
    }

    public Stream<Record> recordList(Predicate<Record> filter) {
        return this.recordList.stream().filter(filter);
    }

    public Record record(int index) {
        return this.recordList.get(index);
    }

    public Stream<TemporalRecord> temporalRecordList(Predicate<TemporalRecord> filter) {
        return this.temporalRecordList.stream().filter(filter);
    }

    public TemporalRecord temporalRecord(int index) {
        return this.temporalRecordList.get(index);
    }

    public Stream<Entity> entityList(Predicate<Entity> filter) {
        return this.entityList.stream().filter(filter);
    }

    public Entity entity(int index) {
        return this.entityList.get(index);
    }

    public Stream<Event> eventList(Predicate<Event> filter) {
        return this.eventList.stream().filter(filter);
    }

    public Event event(int index) {
        return this.eventList.get(index);
    }

    public Stream<Episode> episodeList(Predicate<Episode> filter) {
        return this.episodeList.stream().filter(filter);
    }

    public Episode episode(int index) {
        return this.episodeList.get(index);
    }

    public Stream<Report> reportList(Predicate<Report> filter) {
        return this.reportList.stream().filter(filter);
    }

    public Report report(int index) {
        return this.reportList.get(index);
    }

    public Stream<Cube> cubeList(Predicate<Cube> filter) {
        return this.cubeList.stream().filter(filter);
    }

    public Cube cube(int index) {
        return this.cubeList.get(index);
    }

    public Stream<Checker> checkerList(Predicate<Checker> filter) {
        return this.checkerList.stream().filter(filter);
    }

    public Checker checker(int index) {
        return this.checkerList.get(index);
    }

    public Stream<GeolocatedEntity> geolocatedEntityList(Predicate<GeolocatedEntity> filter) {
        return this.geolocatedEntityList.stream().filter(filter);
    }

    public GeolocatedEntity geolocatedEntity(int index) {
        return this.geolocatedEntityList.get(index);
    }

    public Stream<DynamicEntity> dynamicEntityList(Predicate<DynamicEntity> filter) {
        return this.dynamicEntityList.stream().filter(filter);
    }

    public DynamicEntity dynamicEntity(int index) {
        return this.dynamicEntityList.get(index);
    }

    public Stream<AspectEntity> aspectEntityList(Predicate<AspectEntity> filter) {
        return this.aspectEntityList.stream().filter(filter);
    }

    public AspectEntity aspectEntity(int index) {
        return this.aspectEntityList.get(index);
    }

    public Stream<Element> elementList(Predicate<Element> filter) {
        return this.elementList.stream().filter(filter);
    }

    public Element element(int index) {
        return this.elementList.get(index);
    }

    public Stream<Cluster> clusterList(Predicate<Cluster> filter) {
        return this.clusterList.stream().filter(filter);
    }

    public Cluster cluster(int index) {
        return this.clusterList.get(index);
    }

    public Stream<AbstractAccess> abstractAccessList(Predicate<AbstractAccess> filter) {
        return this.abstractAccessList.stream().filter(filter);
    }

    public AbstractAccess abstractAccess(int index) {
        return this.abstractAccessList.get(index);
    }

    public Stream<Access> accessList(Predicate<Access> filter) {
        return this.accessList.stream().filter(filter);
    }

    public Access access(int index) {
        return this.accessList.get(index);
    }

    public Stream<GlobalAccess> globalAccessList(Predicate<GlobalAccess> filter) {
        return this.globalAccessList.stream().filter(filter);
    }

    public GlobalAccess globalAccess(int index) {
        return this.globalAccessList.get(index);
    }

    public Stream<Categorization> categorizationList(Predicate<Categorization> filter) {
        return this.categorizationList.stream().filter(filter);
    }

    public Categorization categorization(int index) {
        return this.categorizationList.get(index);
    }

    public Stream<AbstractMetric> abstractMetricList(Predicate<AbstractMetric> filter) {
        return this.abstractMetricList.stream().filter(filter);
    }

    public AbstractMetric abstractMetric(int index) {
        return this.abstractMetricList.get(index);
    }

    public Stream<Metric> metricList(Predicate<Metric> filter) {
        return this.metricList.stream().filter(filter);
    }

    public Metric metric(int index) {
        return this.metricList.get(index);
    }

    public Stream<TemporalMetric> temporalMetricList(Predicate<TemporalMetric> filter) {
        return this.temporalMetricList.stream().filter(filter);
    }

    public TemporalMetric temporalMetric(int index) {
        return this.temporalMetricList.get(index);
    }

    public Stream<NameSpace> nameSpaceList(Predicate<NameSpace> filter) {
        return this.nameSpaceList.stream().filter(filter);
    }

    public NameSpace nameSpace(int index) {
        return this.nameSpaceList.get(index);
    }

    public Stream<Ticket> ticketList(Predicate<Ticket> filter) {
        return this.ticketList.stream().filter(filter);
    }

    public Ticket ticket(int index) {
        return this.ticketList.get(index);
    }

    public Stream<Olap> olapList(Predicate<Olap> filter) {
        return this.olapList.stream().filter(filter);
    }

    public Olap olap(int index) {
        return this.olapList.get(index);
    }

    public Stream<Filter> filterList(Predicate<Filter> filter) {
        return this.filterList.stream().filter(filter);
    }

    public Filter filter(int index) {
        return this.filterList.get(index);
    }

    public Stream<OnClickInstant> onClickInstantList(Predicate<OnClickInstant> filter) {
        return this.onClickInstantList.stream().filter(filter);
    }

    public OnClickInstant onClickInstant(int index) {
        return this.onClickInstantList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    public class Clear {
        public void cube(Predicate<Cube> filter) {
            new ArrayList<Cube>(AbstractGraph.this.cubeList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void checker(Predicate<Checker> filter) {
            new ArrayList<Checker>(AbstractGraph.this.checkerList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void cluster(Predicate<Cluster> filter) {
            new ArrayList<Cluster>(AbstractGraph.this.clusterList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void access(Predicate<Access> filter) {
            new ArrayList<Access>(AbstractGraph.this.accessList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void globalAccess(Predicate<GlobalAccess> filter) {
            new ArrayList<GlobalAccess>(AbstractGraph.this.globalAccessList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void categorization(Predicate<Categorization> filter) {
            new ArrayList<Categorization>(AbstractGraph.this.categorizationList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void metric(Predicate<Metric> filter) {
            new ArrayList<Metric>(AbstractGraph.this.metricList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void temporalMetric(Predicate<TemporalMetric> filter) {
            new ArrayList<TemporalMetric>(AbstractGraph.this.temporalMetricList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void nameSpace(Predicate<NameSpace> filter) {
            new ArrayList<NameSpace>(AbstractGraph.this.nameSpaceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void ticket(Predicate<Ticket> filter) {
            new ArrayList<Ticket>(AbstractGraph.this.ticketList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void olap(Predicate<Olap> filter) {
            new ArrayList<Olap>(AbstractGraph.this.olapList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void filter(Predicate<Filter> filter) {
            new ArrayList<Filter>(AbstractGraph.this.filterList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void onClickInstant(Predicate<OnClickInstant> filter) {
            new ArrayList<OnClickInstant>(AbstractGraph.this.onClickInstantList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Cube cube() {
            Cube newElement = (Cube)((Cube)AbstractGraph.this.graph.createRoot(Cube.class, this.stash, this.name)).a$(Cube.class);
            return newElement;
        }

        public Checker checker(Concept record) {
            Checker newElement = (Checker)((Checker)AbstractGraph.this.graph.createRoot(Checker.class, this.stash, this.name)).a$(Checker.class);
            newElement.core$().set((Layer)newElement, "record", Collections.singletonList(record));
            return newElement;
        }

        public Cluster cluster(Catalog catalog, String label, String username) {
            Cluster newElement = (Cluster)((Cluster)AbstractGraph.this.graph.createRoot(Cluster.class, this.stash, this.name)).a$(Cluster.class);
            newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "username", Collections.singletonList(username));
            return newElement;
        }

        public Access access(List<NameSpace> namespaces) {
            Access newElement = (Access)((Access)AbstractGraph.this.graph.createRoot(Access.class, this.stash, this.name)).a$(Access.class);
            newElement.core$().set((Layer)newElement, "namespaces", namespaces);
            return newElement;
        }

        public GlobalAccess globalAccess() {
            GlobalAccess newElement = (GlobalAccess)((GlobalAccess)AbstractGraph.this.graph.createRoot(GlobalAccess.class, this.stash, this.name)).a$(GlobalAccess.class);
            return newElement;
        }

        public Categorization categorization(String label, Expression<List<String>> tags) {
            Categorization newElement = (Categorization)((Categorization)AbstractGraph.this.graph.createRoot(Categorization.class, this.stash, this.name)).a$(Categorization.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "tags", Collections.singletonList(tags));
            return newElement;
        }

        public Metric metric() {
            Metric newElement = (Metric)((Metric)AbstractGraph.this.graph.createRoot(Metric.class, this.stash, this.name)).a$(Metric.class);
            return newElement;
        }

        public TemporalMetric temporalMetric() {
            TemporalMetric newElement = (TemporalMetric)((TemporalMetric)AbstractGraph.this.graph.createRoot(TemporalMetric.class, this.stash, this.name)).a$(TemporalMetric.class);
            return newElement;
        }

        public NameSpace nameSpace(String label) {
            NameSpace newElement = (NameSpace)((NameSpace)AbstractGraph.this.graph.createRoot(NameSpace.class, this.stash, this.name)).a$(NameSpace.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Ticket ticket(String label, String shortLabel, List<Concept> events) {
            Ticket newElement = (Ticket)((Ticket)AbstractGraph.this.graph.createRoot(Ticket.class, this.stash, this.name)).a$(Ticket.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "shortLabel", Collections.singletonList(shortLabel));
            newElement.core$().set((Layer)newElement, "events", events);
            return newElement;
        }

        public Olap olap(String label, NameSpacesLoader nameSpaces, List<Ticket> tickets) {
            Olap newElement = (Olap)((Olap)AbstractGraph.this.graph.createRoot(Olap.class, this.stash, this.name)).a$(Olap.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "nameSpaces", Collections.singletonList(nameSpaces));
            newElement.core$().set((Layer)newElement, "tickets", tickets);
            return newElement;
        }

        public Filter filter(String label, String username) {
            Filter newElement = (Filter)((Filter)AbstractGraph.this.graph.createRoot(Filter.class, this.stash, this.name)).a$(Filter.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "username", Collections.singletonList(username));
            return newElement;
        }

        public OnClickInstant onClickInstant(CatalogList catalogs) {
            OnClickInstant newElement = (OnClickInstant)((OnClickInstant)AbstractGraph.this.graph.createRoot(OnClickInstant.class, this.stash, this.name)).a$(OnClickInstant.class);
            newElement.core$().set((Layer)newElement, "catalogs", Collections.singletonList(catalogs));
            return newElement;
        }

        public Palette palette() {
            Palette newElement = (Palette)((Palette)AbstractGraph.this.graph.createRoot(Palette.class, this.stash, this.name)).a$(Palette.class);
            return newElement;
        }
    }
}

