/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays.requesters;

import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.ui.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.ui.spark.UIFile;
import io.intino.konos.alexandria.ui.spark.UISparkManager;
import io.intino.sumus.box.displays.SumusOlap;
import io.intino.sumus.box.schemas.ChartOption;
import io.intino.sumus.box.schemas.RequestRange;

public class SumusOlapRequester
extends AlexandriaDisplayRequester {
    public SumusOlapRequester(UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    public void execute() throws AlexandriaException {
        SumusOlap display = (SumusOlap)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("addTicket")) {
            display.addTicket((String)this.manager.fromQuery("value", String.class));
            return;
        }
        if (operation.equals("removeTicket")) {
            display.removeTicket((String)this.manager.fromQuery("value", String.class));
            return;
        }
        if (operation.equals("moveTickets")) {
            display.moveTickets((String[])this.manager.fromQuery("value", String[].class));
            return;
        }
        if (operation.equals("updateScale")) {
            display.updateScale((String)this.manager.fromQuery("value", String.class));
            return;
        }
        if (operation.equals("updateRange")) {
            display.updateRange((RequestRange)this.manager.fromQuery("value", RequestRange.class));
            return;
        }
        if (operation.equals("export")) {
            UIFile file = display.export((RequestRange)this.manager.fromQuery("value", RequestRange.class));
            this.manager.write((Object)file.content(), file.label(), file.embedded());
            return;
        }
        if (operation.equals("removeDrillTag")) {
            display.removeDrillTag((String)this.manager.fromQuery("value", String.class));
            return;
        }
        if (operation.equals("selectChart")) {
            display.selectChart((ChartOption)this.manager.fromQuery("value", ChartOption.class));
            return;
        }
        if (operation.equals("removeFilter")) {
            display.removeFilter((String)this.manager.fromQuery("value", String.class));
            return;
        }
        super.execute();
    }
}

