/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.ui.displays.AlexandriaTimeNavigator;
import io.intino.konos.alexandria.ui.model.TimeScale;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusChartDialog;
import io.intino.sumus.box.displays.SumusTimeCrossTable;
import io.intino.sumus.box.displays.builders.ReferenceBuilder;
import io.intino.sumus.box.displays.notifiers.SumusTimeCrossTableDialogNotifier;
import io.intino.sumus.box.schemas.CrossTableQuery;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.rules.Chart;
import io.intino.sumus.helpers.ChartSpec;
import io.intino.sumus.helpers.ChartSpecHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SumusTimeCrossTableDialog
extends SumusChartDialog<SumusTimeCrossTableDialogNotifier, AlexandriaTimeNavigator> {
    private List<Categorization> activeCategorizations = new ArrayList<Categorization>();

    public SumusTimeCrossTableDialog(SumusBox box) {
        super(box, Chart.TimeCrossTable, new AlexandriaTimeNavigator((Box)box));
    }

    @Override
    protected void init() {
        super.init();
        this.sendCategorizations();
    }

    public void query(final CrossTableQuery query) {
        Map<Categorization, List<String>> taggedCategorizationsMap = this.taggedCategorizationsMap(query);
        ChartSpecHandler chartSpecHandler = this.chartSpecHandler();
        chartSpecHandler.clearCategorizationsTag("column");
        chartSpecHandler.clearCategorizationsTag("row");
        chartSpecHandler.selectCategorizations(taggedCategorizationsMap);
        chartSpecHandler.heatMap(query.heatMap() != null ? new ChartSpec.HeatMap(){

            @Override
            public String minColor() {
                return query.heatMap().min();
            }

            @Override
            public String maxColor() {
                return query.heatMap().max();
            }
        } : null);
        chartSpecHandler.update();
    }

    public void updateTemporalCategorizations(List<TemporalCategorization> activeCategorizations) {
        TimeScale scale = this.timeScaleHandler().range().scale();
        this.activeCategorizations = activeCategorizations.stream().filter(c -> SumusTimeCrossTable.isAvailableForScale(c, scale)).collect(Collectors.toList());
        ((SumusTimeCrossTableDialogNotifier)this.notifier).refreshTemporalCategorizationList(ReferenceBuilder.buildList(this.temporalCategorizations()));
    }

    private Map<Categorization, List<String>> taggedCategorizationsMap(CrossTableQuery query) {
        LinkedHashMap<Categorization, List<String>> taggedCategorizationsMap = new LinkedHashMap<Categorization, List<String>>();
        query.cols().forEach(col -> {
            Categorization categorization = this.categorizationOf((String)col);
            taggedCategorizationsMap.put(categorization, Collections.singletonList("column"));
        });
        query.rows().forEach(row -> {
            Categorization categorization = this.categorizationOf((String)row);
            taggedCategorizationsMap.put(categorization, Collections.singletonList("row"));
        });
        return taggedCategorizationsMap;
    }

    @Override
    protected void sendCategorizations() {
        ((SumusTimeCrossTableDialogNotifier)this.notifier).refreshCategorizationList(ReferenceBuilder.buildList(this.categorizations()));
        ((SumusTimeCrossTableDialogNotifier)this.notifier).refreshTemporalCategorizationList(ReferenceBuilder.buildList(this.temporalCategorizations()));
    }

    @Override
    protected List<TemporalCategorization> temporalCategorizations() {
        if (this.activeCategorizations.isEmpty()) {
            return super.temporalCategorizations();
        }
        return this.activeCategorizations.stream().map(c -> (TemporalCategorization)((Object)c)).collect(Collectors.toList());
    }

    @Override
    protected void sendTickets() {
    }

    @Override
    public void addNavigatorListeners(AlexandriaTimeNavigator display) {
        display.onMove(instant -> this.chartSpecHandler().update());
    }
}

