/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.viewmodels.Drill;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusCategorization;
import io.intino.sumus.box.displays.SumusCategorizationContainer;
import io.intino.sumus.box.displays.builders.ReferenceBuilder;
import io.intino.sumus.box.displays.notifiers.SumusCategorizationComparatorNotifier;
import io.intino.sumus.graph.Categorization;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class SumusCategorizationComparator
extends SumusCategorizationContainer<SumusCategorizationComparatorNotifier> {
    private List<BiConsumer<Drill, Boolean>> applyListeners = new ArrayList<BiConsumer<Drill, Boolean>>();
    private List<Consumer<Drill>> quitListeners = new ArrayList<Consumer<Drill>>();
    private Drill drill;
    private Boolean includeGlobalSerie = true;
    private Timer executeDrillTimer = null;
    private static final int MaxTagsSelection = 5;

    public SumusCategorizationComparator(SumusBox box) {
        super(box);
    }

    @Override
    protected void init() {
        super.init();
        this.children(SumusCategorization.class).forEach(cd -> cd.maxSelection(5));
        ((SumusCategorizationComparatorNotifier)this.notifier).refreshIncludeGlobalSerie(this.includeGlobalSerie);
    }

    @Override
    protected void sendRefreshCategorizationList(List<Categorization> categorizationList) {
        ((SumusCategorizationComparatorNotifier)this.notifier).refreshCategorizationList(ReferenceBuilder.buildList(categorizationList));
    }

    @Override
    protected void sendRefreshTemporalCategorizationList(List<TemporalCategorization> categorizationList) {
    }

    public void apply() {
        this.applyListeners.forEach(l -> l.accept(this.clonedDrill(), this.includeGlobalSerie));
    }

    public void onApply(BiConsumer<Drill, Boolean> consumer) {
        this.applyListeners.add(consumer);
    }

    public void quit() {
        this.quitListeners.forEach(l -> l.accept(this.clonedDrill()));
    }

    public void onQuit(Consumer<Drill> consumer) {
        this.quitListeners.add(consumer);
    }

    public void includeGlobalSerie(Boolean value) {
        this.includeGlobalSerie = value;
        ((SumusCategorizationComparatorNotifier)this.notifier).refreshIncludeGlobalSerie(this.includeGlobalSerie);
        this.applyDelayed();
    }

    @Override
    protected void addListeners(SumusCategorization categorizationDisplay) {
        categorizationDisplay.onSelect(tags -> this.updateDrill(categorizationDisplay));
    }

    private void updateDrill(SumusCategorization categorizationDisplay) {
        this.drill = categorizationDisplay.asDrill();
        this.applyDelayed();
    }

    private void applyDelayed() {
        if (this.executeDrillTimer != null) {
            this.executeDrillTimer.cancel();
        }
        this.executeDrillTimer = new Timer();
        this.executeDrillTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (SumusCategorizationComparator.this.drill == null) {
                    SumusCategorizationComparator.this.quit();
                } else {
                    SumusCategorizationComparator.this.apply();
                }
                SumusCategorizationComparator.this.executeDrillTimer = null;
            }
        }, 1000L);
    }

    private Drill clonedDrill() {
        if (this.drill == null) {
            return null;
        }
        return new Drill(this.drill.categorization, this.drill.tags);
    }
}

