/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.viewmodels.Drill;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.analytics.viewmodels.TagView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.builders.CategorizationViewBuilder;
import io.intino.sumus.box.displays.builders.TagViewBuilder;
import io.intino.sumus.box.displays.notifiers.SumusCategorizationNotifier;
import io.intino.sumus.box.schemas.CategorizationToggleDialog;
import io.intino.sumus.graph.Categorization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SumusCategorization
extends SumusDisplay<SumusCategorizationNotifier> {
    private final List<Consumer<List<String>>> selectListeners = new ArrayList<Consumer<List<String>>>();
    private final List<String> tags = new ArrayList<String>();
    private Categorization categorization;

    public SumusCategorization(SumusBox box) {
        super(box);
    }

    public void categorization(Categorization categorization) {
        this.categorization = categorization;
    }

    public Categorization categorization() {
        return this.categorization;
    }

    public void toggle(CategorizationToggleDialog dialog) {
        this.select(dialog.tags());
    }

    public void onSelect(Consumer<List<String>> consumer) {
        this.selectListeners.add(consumer);
        this.children(SumusCategorization.class).forEach(d -> d.onSelect(consumer));
    }

    public Drill asDrill() {
        return this.tags.size() > 0 ? new Drill(this.categorization, this.tags) : null;
    }

    public boolean hasFilterCondition() {
        return this.tags.size() > 0;
    }

    public FilterCondition asFilterCondition() {
        return new FilterCondition(this.categorization, this.tags);
    }

    public void toggle(String tag) {
        if (this.tags.contains(tag)) {
            this.tags.remove(tag);
        } else {
            this.tags.add(tag);
        }
        this.refreshSelected();
        this.notifySelection();
    }

    public void select(String[] tags) {
        this.select(Arrays.asList(tags));
    }

    public void select(List<String> tagList) {
        this.tags.clear();
        List<String> calculate = this.categorization.tags(this.accessList());
        tagList.forEach(key -> {
            List foundTags = calculate.stream().filter(c -> c.equals(key)).collect(Collectors.toList());
            if (foundTags.size() > 0) {
                this.tags.add((String)foundTags.get(0));
            }
        });
        this.refreshSelected();
        this.notifySelection();
    }

    public void selectAll() {
        this.tags.clear();
        this.tags.addAll(this.categorization.tags(this.accessList()));
        this.refreshSelected();
        this.notifySelection();
    }

    public void selectNone() {
        this.tags.clear();
        this.refreshSelected();
        this.notifySelection();
    }

    public void maxSelection(int count) {
        ((SumusCategorizationNotifier)this.notifier).refreshMaxSelection(count);
    }

    public void refresh() {
        super.refresh();
        ((SumusCategorizationNotifier)this.notifier).refreshCategorization(CategorizationViewBuilder.build(io.intino.sumus.analytics.viewmodels.CategorizationViewBuilder.build(this.categorization, this.accessList())));
    }

    private void notifySelection() {
        this.selectListeners.forEach(c -> c.accept(this.tags));
    }

    private void refreshSelected() {
        ((SumusCategorizationNotifier)this.notifier).refreshSelected(TagViewBuilder.buildList(this.tags.stream().map(TagView::new).collect(Collectors.toList())));
    }
}

