/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.LogFormatter;
import io.intino.konos.alexandria.ui.UIAlexandriaSpark;
import io.intino.konos.alexandria.ui.UIBox;
import io.intino.konos.alexandria.ui.UiElements;
import io.intino.konos.alexandria.ui.displays.Soul;
import io.intino.konos.alexandria.ui.services.AuthService;
import io.intino.konos.alexandria.ui.services.EditorService;
import io.intino.sumus.box.PlatformUi;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.SumusConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBox
extends UIBox {
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");
    protected SumusConfiguration configuration;
    protected Map<String, Soul> uiSouls = new HashMap<String, Soul>();
    private List<UIBox.SoulsClosed> soulsClosedListeners = new ArrayList<UIBox.SoulsClosed>();
    private AuthService authService;
    private EditorService editorService;

    public AbstractBox(String[] args) {
        this(new SumusConfiguration(args));
    }

    public AbstractBox(SumusConfiguration configuration) {
        this.configuration = configuration;
        this.initLogger();
        this.authService = null;
        this.editorService = null;
        UIAlexandriaSpark.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/", (AuthService)this.authService, (EditorService)this.editorService);
    }

    public SumusConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        return this;
    }

    public Box open() {
        if (this.owner != null) {
            this.owner.open();
        }
        this.initLogger();
        this.initUI();
        this.initRESTServices();
        this.initJMXServices();
        this.initJMSServices();
        this.initDataLake();
        this.initTasks();
        this.initSlackBots();
        return this;
    }

    public void close() {
        if (this.owner != null) {
            this.owner.close();
        }
        UIAlexandriaSpark.instance().stop();
    }

    public List<Soul> souls() {
        return new ArrayList<Soul>(this.uiSouls.values());
    }

    public Optional<Soul> soul(String clientId) {
        return Optional.ofNullable(this.uiSouls.get(clientId));
    }

    public void registerSoul(String clientId, Soul soul) {
        this.uiSouls.put(clientId, soul);
    }

    public void unRegisterSoul(String clientId) {
        this.uiSouls.remove(clientId);
        if (this.uiSouls.size() <= 0) {
            this.notifySoulsClosed();
        }
    }

    public void onSoulsClosed(UIBox.SoulsClosed listener) {
        this.soulsClosedListeners.add(listener);
    }

    private void notifySoulsClosed() {
        this.soulsClosedListeners.forEach(l -> l.accept());
    }

    protected abstract AuthService authService(URL var1);

    protected abstract EditorService editorService(URL var1);

    public EditorService editorService() {
        return this.editorService;
    }

    private void initRESTServices() {
    }

    private void initJMSServices() {
    }

    private void initJMXServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
        UIAlexandriaSpark sparkInstance = UIAlexandriaSpark.instance();
        PlatformUi.init(sparkInstance, (SumusBox)this);
        UiElements.initDisplays((UIAlexandriaSpark)sparkInstance);
        sparkInstance.start();
        logger.info("UI PlatformUi: started!");
    }

    private void initDataLake() {
    }

    private void initTasks() {
    }

    private void initLogger() {
        java.util.logging.Logger logger = java.util.logging.Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new LogFormatter("log"));
        logger.setUseParentHandlers(false);
        logger.addHandler(handler);
    }

    private static URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

