/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus;

import io.intino.konos.alexandria.ui.model.TimeScale;
import java.time.Instant;

public class TimeStamp {
    private Instant instant;
    private TimeScale scale;

    public TimeStamp(Instant instant, TimeScale scale) {
        this.instant = scale.normalise(instant);
        this.scale = scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeStamp timeStamp = (TimeStamp)o;
        if (!this.instant.equals(timeStamp.instant)) {
            return false;
        }
        return this.scale == timeStamp.scale;
    }

    public int hashCode() {
        int result = this.instant.hashCode();
        result = 31 * result + this.scale.hashCode();
        return result;
    }

    public String toString() {
        return this.instant.toString() + this.scale.toString();
    }

    public Instant instant() {
        return this.instant;
    }

    public TimeScale scale() {
        return this.scale;
    }

    public boolean contains(TimeStamp timeStamp) {
        if (this.scale.ordinal() > timeStamp.scale.ordinal()) {
            return false;
        }
        if (this.equals(timeStamp)) {
            return true;
        }
        return this.scale.normalise(timeStamp.instant).equals(this.instant);
    }
}

