/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus;

import io.intino.sumus.helpers.UtcDateTime;
import io.intino.tara.io.Stash;
import io.intino.tara.magritte.stores.FileSystemStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SumusStore
extends FileSystemStore {
    private Map<String, Instant> minNameSpaceInstants = new HashMap<String, Instant>();
    private Map<String, Instant> maxNameSpaceInstants = new HashMap<String, Instant>();

    public SumusStore(File file) {
        this(file, 3600000L);
    }

    public SumusStore(File file, long nameSpaceInstantCacheMillisPeriod) {
        super(file);
        this.createNameSpaceInstantReloader(nameSpaceInstantCacheMillisPeriod);
    }

    public File storeFolder() {
        return this.file;
    }

    public void writeStash(Stash stash, String path) {
        super.writeStash(stash, path);
    }

    public Stash stashFrom(String path) {
        Stash stash = super.stashFrom(path);
        return stash == null ? this.defaultStash() : stash;
    }

    private Stash defaultStash() {
        Stash defaultStash = new Stash();
        defaultStash.language = "Sumus";
        return defaultStash;
    }

    public Instant minInstantForNameSpace(String nameSpace) {
        if (!this.minNameSpaceInstants.containsKey(nameSpace)) {
            List<File> years = this.minYears(this.years(nameSpace));
            Instant instant = this.findInLowerThanDayScale(years).findFirst().orElseGet(() -> this.findInLowerThanYearScale(years).findFirst().orElse(Instant.now(Clock.systemUTC())));
            this.minNameSpaceInstants.put(nameSpace, instant);
        }
        return this.minNameSpaceInstants.get(nameSpace);
    }

    public Instant maxInstantForNameSpace(String nameSpace) {
        if (!this.maxNameSpaceInstants.containsKey(nameSpace)) {
            List<File> years = this.maxYears(this.years(nameSpace));
            Instant instant = this.findInLowerThanDayScale(years).reduce((l, r) -> r).orElseGet(() -> this.findInLowerThanYearScale(years).reduce((l, r) -> r).orElse(Instant.now(Clock.systemUTC())));
            this.maxNameSpaceInstants.put(nameSpace, instant);
        }
        return this.maxNameSpaceInstants.get(nameSpace);
    }

    public void clearNameSpaceRanges() {
        this.minNameSpaceInstants.clear();
        this.maxNameSpaceInstants.clear();
    }

    public String absoluteFilename(String storeFilename) {
        return this.file.getAbsoluteFile() + File.separator + storeFilename;
    }

    private Stream<Instant> findInLowerThanDayScale(List<File> years) {
        return years.stream().map(File::toPath).flatMap(p -> this.list((Path)p).stream()).flatMap(p -> this.list((Path)p).stream()).map(Path::toFile).filter(this::isNotMacFile).map(this::toInstant).sorted();
    }

    private Stream<Instant> findInLowerThanYearScale(List<File> years) {
        return years.stream().map(File::toPath).flatMap(p -> this.list((Path)p).stream()).map(Path::toFile).filter(this::isNotMacFile).map(this::toInstantUntilDay).sorted();
    }

    private Instant toInstant(File file) {
        File dayFile = file.getParentFile();
        int day = Integer.valueOf(dayFile.getName());
        File yearFile = dayFile.getParentFile();
        int year = Integer.valueOf(yearFile.getName());
        String time = this.afterDash(file.getName());
        int hour = Integer.valueOf(time.substring(0, 2));
        int minutes = time.length() <= 2 ? 0 : Integer.valueOf(time.substring(2));
        return new UtcDateTime(year, 1, 1, hour, minutes).plusDays(day - 1).toInstant();
    }

    private Instant toInstantUntilDay(File file) {
        int day = Integer.valueOf(this.afterDash(file.getName()));
        File yearFile = file.getParentFile();
        int year = Integer.valueOf(yearFile.getName());
        return new UtcDateTime(year, 1, 1, 0, 0).plusDays(day - 1).toInstant();
    }

    private List<File> minYears(List<Path> years) {
        Pattern pattern = Pattern.compile("\\d+");
        int year = Calendar.getInstance().get(1);
        String min = String.valueOf(years.stream().mapToLong(d -> {
            Matcher matcher = pattern.matcher(d.toString());
            return matcher.find() ? Long.valueOf(matcher.group()) : 0L;
        }).min().orElse(year));
        return years.stream().filter(d -> d.toString().contains(String.valueOf(min))).map(Path::toFile).sorted(File::compareTo).collect(Collectors.toList());
    }

    private List<File> maxYears(List<Path> years) {
        Pattern pattern = Pattern.compile("\\d+");
        int year = Calendar.getInstance().get(1);
        String max = String.valueOf(years.stream().mapToLong(d -> {
            Matcher matcher = pattern.matcher(d.toString());
            return matcher.find() ? Long.valueOf(matcher.group()) : 0L;
        }).max().orElse(year));
        return years.stream().filter(d -> d.toString().contains(String.valueOf(max))).map(Path::toFile).sorted(File::compareTo).collect(Collectors.toList());
    }

    private List<Path> years(String nameSpace) {
        List<Path> directories = this.list(new File(this.file, nameSpace + "-digests").toPath(), this.directoryFilter());
        directories.addAll(this.list(new File(this.file, nameSpace + "-events").toPath(), this.directoryFilter()));
        return directories.stream().map(d -> this.list((Path)d, this.directoryFilter()).stream()).flatMap(p -> p).collect(Collectors.toList());
    }

    private boolean isMacFile(Path path) {
        return path.toString().contains(".DS_Store");
    }

    private boolean isNotMacFile(File file) {
        return !file.toString().contains(".DS_Store");
    }

    private List<Path> list(Path path) {
        return this.list(path, entry -> true);
    }

    private List<Path> list(Path path, DirectoryStream.Filter<Path> filter) {
        try {
            DirectoryStream<Path> paths = Files.newDirectoryStream(path, filter);
            Iterable iterable = paths::iterator;
            List<Path> result = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
            paths.close();
            return result;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private DirectoryStream.Filter<Path> directoryFilter() {
        return entry -> Files.isDirectory(entry, new LinkOption[0]) && !this.isMacFile((Path)entry);
    }

    private String afterDash(String fileName) {
        if (!fileName.contains("-")) {
            return fileName;
        }
        if (!(fileName = fileName.substring(fileName.indexOf("-") + 1, fileName.lastIndexOf("."))).contains("-")) {
            return fileName;
        }
        return fileName.substring(0, fileName.indexOf("-"));
    }

    private void createNameSpaceInstantReloader(long nameSpaceInstantCacheMillisPeriod) {
        Timer nameSpaceInstantReloader = new Timer();
        nameSpaceInstantReloader.schedule(new TimerTask(){

            @Override
            public void run() {
                SumusStore.this.clearNameSpaceRanges();
            }
        }, 0L, nameSpaceInstantCacheMillisPeriod);
    }
}

