package io.intino.sumus.queries;

import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.sumus.analytics.FormulaLoader;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.graph.*;
import io.intino.sumus.queries.digest.Query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistogramQuery extends AbstractQuery {
	private final List<Ticket> tickets = new ArrayList<>();
	private final Map<Categorization, List<String>> filters = new HashMap<>();
	private TimeSeriesQuery.SortBy sortBy = null;
	private Categorization categorization = null;
	private NameSpace nameSpace;
	private TimeRange timeRange;
	private List<AbstractAccess> accessList = new ArrayList<>();

	private HistogramQuery() {
	}

	public List<Ticket> tickets() {
		return tickets;
	}

	public Categorization categorization() {
		return categorization;
	}

	public Map<Categorization, List<String>> filters() {
		return filters;
	}

	public TimeSeriesQuery.SortBy sortBy() {
		return sortBy;
	}

	public NameSpace nameSpace() {
		return nameSpace;
	}

	public TimeRange timeRange() {
		return timeRange;
	}

	public List<AbstractAccess> accessList() {
		return accessList;
	}

	public Query toRawQuery(FormulaLoader loader, List<String> tags) {
		Query result = new Query();

		addScope(result);

		loader.formulas(tickets).forEach(formula -> result.add(nameSpace, formula));
		result.add(timeRange);

		filters().values().forEach(result::filter);
		tags.forEach(result::drill);

		return result;
	}

	public TimeScale scale() {
		return timeRange.scale();
	}

	public static class Builder extends AbstractQuery.Builder<HistogramQuery> {

		public Builder() {
			super(new HistogramQuery());
		}

		public HistogramQuery build(NameSpace nameSpace, Categorization categorization, TimeRange timeRange, TimeSeriesQuery.SortBy sortBy) {
			nameSpace(nameSpace);
			categorization(categorization);
			timeRange(timeRange);
			sortBy(sortBy);
			return query;
		}

		public Builder addTickets(List<Ticket> tickets) {
			query.tickets.addAll(tickets);
			return this;
		}

		public Builder addTicket(Ticket ticket) {
			query.tickets.add(ticket);
			return this;
		}

		private Builder nameSpace(NameSpace nameSpace) {
			query.nameSpace = nameSpace;
			return this;
		}

		private Builder timeRange(TimeRange timeRange) {
			query.timeRange = timeRange;
			return this;
		}

		private Builder categorization(Categorization categorization) {
			query.categorization = categorization;
			return this;
		}

		private Builder sortBy(TimeSeriesQuery.SortBy sortBy) {
			query.sortBy = sortBy;
			return this;
		}

		public Builder filter(Categorization categorization, List<String> tag) {
			query.filters.put(categorization, tag);
			return this;
		}

		public Builder filter(List<FilterCondition> filterConditions) {
			filterConditions.forEach(filter -> query.filters.put(filter.categorization, filter.tags));
			return this;
		}

		public Builder accessList(List<AbstractAccess> accessList) {
			query.accessList = accessList;
			return this;
		}
	}
}
