package io.intino.sumus.queries;

import io.intino.konos.alexandria.activity.services.push.User;
import io.intino.tara.magritte.Concept;

public class EntityQuery extends AbstractQuery {
	private Concept entity;
	private String condition = null;
	private User user = null;

	private EntityQuery() {
	}

	public Concept entity() {
		return entity;
	}

	public String condition() {
		return condition;
	}

	public User user() {
		return user;
	}

	public static class Builder extends AbstractQuery.Builder<EntityQuery> {

		public Builder() {
			super(new EntityQuery());
		}

		public EntityQuery build(Concept entity, User user) {
			query.entity = entity;
			query.user = user;
			return query;
		}

		public EntityQuery.Builder condition(String condition) {
			query.condition = condition;
			return this;
		}
	}

}
