package io.intino.sumus.queries;

import io.intino.sumus.TimeStamp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Drill {
	private final String id;
	private final List<String> tags = new ArrayList<>();
	private TimeStamp timeStamp = null;

	public Drill(String id, Collection<String> tags) {
		this.id = id;
		this.tags.addAll(tags);
	}

	public Drill(String id, TimeStamp timeStamp) {
		this.id = id;
		this.timeStamp = timeStamp;
	}

	@Override
	public String toString() {
		return id;
	}

	public List<String> tags() {
		return new ArrayList<>(tags);
	}

	public boolean contains(Collection<String> tags) {
		for (String tag : this.tags) if (!tags.contains(tag)) return false;
		return true;
	}

	public boolean contains(TimeStamp timeStamp) {
		return this.timeStamp.contains(timeStamp);
	}

	public TimeStamp timeStamp() {
		return timeStamp;
	}

	public boolean isTemporal() {
		return timeStamp != null;
	}
}
