package io.intino.sumus.queries;

import io.intino.sumus.graph.Categorization;
import io.intino.sumus.queries.digest.Query;

import java.util.*;

public class AbstractQuery {
	protected Scope scope = null;

	public Optional<Scope> scope() {
		return Optional.ofNullable(scope);
	}

	protected Map<Categorization, List<String>> toMap(List<io.intino.sumus.analytics.viewmodels.FilterCondition> filters) {
		Map<Categorization, List<String>> result = new HashMap<>();

		filters.forEach(fc -> {
			Categorization categorization = fc.categorization;
			List<String> tags = fc.tags;

			if (!result.containsKey(categorization))
				result.put(categorization, new ArrayList<>());

			List<String> categorizationTags = result.get(categorization);
			categorizationTags.removeAll(tags);
			categorizationTags.addAll(tags);
		});

		return result;
	}

	protected void addScope(Query query) {
		if (scope == null) return;
		scope.tags().forEach(query::filter);
		// TODO review with mario with the parametric olap
//        scope.records().forEach(records -> query.filter(records.toArray(new Record[0])));
	}

	protected void addScope(io.intino.sumus.queries.temporalrecord.Query query) {
		if (scope == null) return;
		scope.tags().forEach(query::filter);
		// TODO review with mario with the parametric olap
//        scope.records().forEach(records -> query.filter(records.toArray(new Record[0])));
	}

	public static class Builder<Q extends AbstractQuery> {
		protected final Q query;

		public Builder(Q query) {
			this.query = query;
		}

		public <B extends AbstractQuery.Builder> B scope(Scope scope) {
			query.scope = scope;
			return (B) this;
		}
	}

}
