package io.intino.sumus.helpers;

import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.services.push.User;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.queries.TemporalRecordQuery;
import io.intino.sumus.queries.temporalrecord.QueryExecutor;
import io.intino.tara.magritte.Node;

import java.util.ArrayList;
import java.util.List;

public class TemporalRecordHelper extends Helper {
    private final SumusBox box;

    public TemporalRecordHelper(SumusBox box) {
        this.box = box;
    }

    public TimeRange recordRange(List<NameSpace> nameSpaces) {
        return PathBuilder.range(nameSpaces);
    }

    public List<TemporalRecord> records(TemporalRecordQuery query) {
        return new ArrayList<>(QueryExecutor.execute(query.toRawQuery()).values());
    }

    public TemporalRecord record(String id, User user) {
        Node node = box.graph().core$().clone().load(id, false);
        if (node == null) return null;
        return node.as(TemporalRecord.class);
    }

}
