package io.intino.sumus.helpers;

import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import io.intino.konos.alexandria.activity.services.push.User;
import io.intino.sumus.SumusStore;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.SumusGraph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class NameSpaceHandler {
	private final SumusGraph graph;
	private Map<String, NameSpace> selection = new HashMap<>();
	private List<Consumer<NameSpace>> listeners = new ArrayList<>();

	public NameSpaceHandler(SumusGraph graph) {
		this.graph = graph;
	}

	public void onSelect(Consumer<NameSpace> listener) {
		this.listeners.add(listener);
	}

	public void removeSelectListener(Consumer<NameSpace> listener) {
		this.listeners.remove(listener);
	}

	public NameSpace selectedNameSpace(ActivitySession session) {
		String id = idOf(session);

		if (!selection.containsKey(id)) {
			List<NameSpace> nameSpaces = nameSpaces(session.user());
			if (nameSpaces.size() > 0)
				selection.put(id, nameSpaces.get(0));
		}

		return selection.get(id);
	}

	public NameSpaceHandler select(ActivitySession session, String key) {
		select(session, nameSpaces(session.user()).stream().filter(n -> n.name$().equals(key) || n.label().equals(key)).findFirst().orElse(null));
		return this;
	}

	public NameSpaceHandler select(ActivitySession session, NameSpace nameSpace) {
		selection.put(idOf(session), nameSpace);
		clearNameSpaceRanges();
		this.listeners.forEach(l -> l.accept(nameSpace));
		return this;
	}

	private String idOf(ActivitySession session) {
		return session.user() != null ? session.user().username() : session.id();
	}

	public List<NameSpace> nameSpaces(User user) {
		return graph.nameSpaces(user);
	}

	private void clearNameSpaceRanges() {
		SumusStore store = (SumusStore) graph.core$().store();
		store.clearNameSpaceRanges();
	}

}
